
local BabbleBoss = AceLibrary("Babble-Boss-2.2");
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

AtlasLoot_Data["AtlasLootExpansionItems"] = {

    EmptyInstance = {};

	----------------------------
	--- Burning Crusade Keys ---
	----------------------------

    BCKeys = {
        { 0, "INV_Box_01", "=q6=#j1#", "" },
        { 27991, "INV_Misc_Key_02", "=q1=Shadow Labyrinth Key", "=ds=#e9#" },
        { 28395, "INV_Misc_Key_02", "=q1=Shattered Halls Key", "=ds=#e9#" },
        { 31084, "INV_DataCrystal03", "=q1=Key to the Arcatraz", "=ds=#e9#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#j3#", "" },
        { 30622, "INV_Misc_Key_13", "=q1=Flamewrought Key", "=ds=#e9# =q6=#m7#" },
        { 30637, "INV_Misc_Key_13", "=q1=Flamewrought Key", "=ds=#e9# =q6=#m6#" },
        { 30623, "INV_Misc_Key_13", "=q1=Reservoir Key", "=ds=#e9#" },
        { 30633, "INV_Misc_Key_11", "=q1=Auchenai Key", "=ds=#e9#" },
        { 30635, "INV_Misc_Key_04", "=q1=Key of Time", "=ds=#e9#" },
        { 30634, "INV_Misc_Key_09", "=q1=Warpforged Key", "=ds=#e9#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#j2#", "" },
        { 32649, "INV_Jewelry_Amulet_04", "=q4=Medallion of Karabor", "=ds=#e9#, #s2#" },
        { 31704, "INV_DataCrystal11", "=q1=The Tempest Key", "=ds=#e9#" },
        { 24490, "INV_Misc_Key_07", "=q1=The Master's Key", "=ds=#e9#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#m20#", "" },
        { 32092, "INV_Qiraj_Hiltornate", "=q3=The Eye of Haramad", "=ds=#m27#" },
        { 24140, "INV_Misc_Urn_01", "=q1=Blackened Urn", "=ds=#m27#" },
        { 32449, "INV_Misc_Gem_Pearl_04", "=q1=Essence-Infused Moonstone", "=ds=#m27#" },
	};

	-------------------------------------------
	--- Hellfire Citadel: Hellfire Ramparts ---
	-------------------------------------------

    HCRampWatchkeeper = {
        { 24024, "INV_Shoulder_01", "=q3=Pauldrons of Arcane Rage", "=ds=#s3#, #a1#", "14.69%" },
        { 24023, "INV_Bracer_07", "=q3=Bracers of Finesse", "=ds=#s8#, #a2#", "13.29%" },
        { 24022, "INV_Pants_Leather_15", "=q3=Scale Leggings of the Skirmisher", "=ds=#s11#, #a3#", "14.38%" },
        { 24021, "INV_Chest_Plate03", "=q3=Light-Touched Breastplate", "=ds=#s5#, #a4#", "13.03%" },
        { 24020, "INV_Sword_63", "=q3=Shadowrend Longblade", "=ds=#h3#, #w10#", "13.09%" },
        { 0,"","","" },
        { 23881, "INV_Weapon_Shortblade_29", "=q1=Gargolmar's Hand", "=ds=#m3#", "100%" },
	};
        
    HCRampWatchkeeperHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30593, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Iridescent Fire Opal", "=ds=#e7#", "11.11%" },
        { 30594, "INV_Jewelcrafting_Talasite_03", "=q4=Effulgent Chrysoprase", "=ds=#e7#", "12.35%" },
        { 30592, "INV_Jewelcrafting_Talasite_03", "=q4=Steady Chrysoprase", "=ds=#e7#", "8.64%" },
        { 0,"","","" },
        { 27448, "INV_Misc_Cape_11", "=q3=Cloak of the Everliving", "=ds=#s4#", "28.37%" },
        { 27451, "INV_Boots_Cloth_05", "=q3=Boots of the Darkwalker", "=ds=#s12#, #a1#", "16.61%" },
        { 27450, "INV_Boots_Chain_03", "=q3=Wild Stalker Boots", "=ds=#s12#, #a3#", "14.19%" },
        { 27447, "INV_Bracer_18", "=q3=Bracers of Just Rewards", "=ds=#s8#, #a4#", "13.84%" },
        { 27449, "INV_Shield_05", "=q3=Blood Knight Defender", "=ds=#w8#", "13.15%" },
	};
    
    HCRampOmor = {
        { 24090, "INV_Gauntlets_10", "=q3=Bloodstained Ravager Gauntlets", "=ds=#s9#, #a3#", "12.14%" },
        { 24091, "INV_Belt_33", "=q3=Tenacious Defender", "=ds=#s10#, #a4#", "12.67%" },
        { 24073, "INV_Jewelry_Necklace_22", "=q3=Garotte-String Necklace", "=ds=#s2#", "11.60%" },
        { 24096, "INV_Jewelry_Amulet_05", "=q3=Heartblood Prayer Beads", "=ds=#s2#", "11.15%" },
        { 24094, "INV_Hammer_05", "=q3=Heart Fire Warhammer", "=ds=#h2#, #w6#", "14.76%" },
        { 24069, "INV_Staff_46", "=q3=Crystalfire Staff", "=ds=#w9#", "12.43%" },
        { 0,"","","" },
        { 23886, "Ability_WarStomp", "=q1=Omor's Hoof", "=ds=#m3#", "100%" },
	};
        
    HCRampOmorHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 0,"","","" },
        { 27466, "INV_Helmet_70", "=q3=Headdress of Alacrity", "=ds=#s1#, #a1#", "12.10%" },
        { 27462, "INV_Bracer_13", "=q3=Crimson Bracers of Gloom", "=ds=#s8#, #a1#", "7.12%" },
        { 27467, "INV_Boots_Cloth_06", "=q3=Silent-Strider Kneeboots", "=ds=#s12#, #a2#", "16.37%" },
        { 27478, "INV_Belt_09", "=q3=Girdle of the Blasted Reaches", "=ds=#s10#, #a3#", "14.59%" },
        { 27539, "INV_Shoulder_37", "=q3=Justice Bearer's Pauldrons", "=ds=#s3#, #a4#", "8.90%" },
        { 27906, "INV_Chest_Plate08", "=q3=Crimsonforge Breastplate", "#s5#, #a4#", "12.10%" },
        { 27464, "INV_Jewelry_Necklace_17", "=q3=Omor's Unyielding Will", "=ds=#s2#", "13.52%" },
        { 27895, "INV_Jewelry_Ring_50Naxxramas", "=q3=Band of Many Prisms", "=ds=#s13#", "11.74%" },
        { 27477, "INV_Staff_24", "=q3=Faol's Signet of Cleansing", "=ds=#s15#", "10.32%" },
        { 27463, "INV_Weapon_Shortblade_31", "=q3=Terror Flame Dagger", "=ds=#h1#, #w4#", "8.90%" },
        { 27476, "INV_Mace_44", "=q3=Truncheon of Five Hells", "=ds=#h1#, #w6#", "9.25%" },
        { 0,"","","" },
        { 0,"","","" },
        { 30593, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Iridescent Fire Opal", "=ds=#e7#", "11.11%" },
        { 30594, "INV_Jewelcrafting_Talasite_03", "=q4=Effulgent Chrysoprase", "=ds=#e7#", "12.35%" },
        { 30592, "INV_Jewelcrafting_Talasite_03", "=q4=Steady Chrysoprase", "=ds=#e7#", "8.64%" },
        { 0,"","","" },
        { 27465, "INV_Gauntlets_15", "=q3=Mana-Etched Gloves", "=ds=#s9#, #a1#", "11.74%" },
	};
        
    HCRampVazruden = {
        { 23892, "INV_Scroll_04", "=q1=Ominous Letter", "=ds=#m2#", "100%" },
	};
        
    HCRampNazan = {
        { 23901, "INV_Misc_Head_Dragon_Red", "=q1=Nazan's Head", "=ds=#m3#", "100%" },
	};
        
    HCRampFelIronChest = {
        { 24150, "INV_Misc_Cape_17", "=q3=Mok'Nathal Wildercloak", "=ds=#s4#", "15.65%" },
        { 24083, "INV_Pants_Plate_09", "=q3=Lifegiver Britches", "=ds=#s11#, #a1#", "17.00%" },
        { 24063, "INV_Belt_29", "=q3=Shifting Sash of Midnight", "=ds=#s10#, #a2#", "17.25%" },
        { 24046, "INV_Pants_Plate_10", "=q3=Kilt of Rolling Thunders", "=ds=#s11#, #a3#", "15.96%" },
        { 24064, "INV_Boots_Plate_04", "=q3=Ironsole Clompers", "=ds=#s12#, #a4#", "13.80%" },
        { 24045, "INV_Jewelry_Ring_26", "=q3=Band of Renewal", "=ds=#s13#", "14.44%" },
        { 24154, "INV_Jewelry_Ring_24", "=q3=Witching Band", "=ds=#s13#", "13.23%" },
        { 24151, "INV_Jewelry_Ring_17", "=q3=Mok'Nathal Clan Ring", "=ds=#s13#", "15.45%" },
        { 24044, "INV_Weapon_Halberd13", "=q3=Hellreaver", "=ds=#w7#", "13.91%" },
        { 24155, "INV_Staff_51", "=q3=Ursol's Claw", "=ds=#w9#", "16.21%" },     
	};
        
    HCRampFelIronChestHEROIC = {
        { 29264, "INV_Belt_22", "=q4=Tree-Mender's Belt", "=ds=#s10#, #a2#", "16.05%" },
        { 32077, "Inv_Gauntlets_11", "=q4=Wrath Infused Gauntlets", "=ds=#s9#, #a3#" },
        { 29238, "INV_Belt_27", "=q4=Lion's Heart Girdle", "=ds=#s10#, #a4#", "14.81%" },
        { 29346, "INV_Sword_38", "=q4=Feltooth Eviscerator", "=ds=#h1#, #w4#", "5.56%" },
        { 0,"","","" },
        { 27452, "INV_Bracer_10", "=q3=Light Scribe Bands", "=ds=#s8#, #a1#", "11.73%" },
        { 27461, "INV_Chest_Leather_08", "=q3=Chestguard of the Prowler", "=ds=#s5#, #a2#", "11.73%" },
        { 27456, "INV_Chest_Cloth_07", "=q3=Raiments of Nature's Breath", "=ds=#s5#, #a2#", "19.75%" },
        { 27454, "INV_Shoulder_23", "=q3=Volcanic Pauldrons", "=ds=#s3#, #a3#", "16.66%" },
        { 27458, "INV_Pants_Cloth_11", "=q3=Oceansong Kilt", "=ds=#s11#, #a3#", "10.49%" },
        { 27455, "INV_Helmet_12", "=q3=Irondrake Faceguard", "=ds=#s1#, #a4#", "11.11%" },
        { 27459, "INV_Bracer_06", "=q3=Vambraces of Daring", "=ds=#s8#, #a4#", "10.49%" },
        { 27457, "INV_Gauntlets_09", "=q3=Life Bearer's Gauntlets", "=ds=#s9#, #a4#", "8.02%" },
        { 27453, "INV_Jewelry_Ring_38", "=q3=Averinn's Ring of Slaying", "=ds=#s13#", "14.20%" },
        { 27460, "INV_Jewelry_Ring_AhnQiraj_03", "=q3=Reavers' Ring", "=ds=#s13#", "17.90%" },
        { 30593, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Iridescent Fire Opal", "=ds=#e7#", "11.11%" },
        { 30594, "INV_Jewelcrafting_Talasite_03", "=q4=Effulgent Chrysoprase", "=ds=#e7#", "12.35%" },
        { 30592, "INV_Jewelcrafting_Talasite_03", "=q4=Steady Chrysoprase", "=ds=#e7#", "8.64%" },
	};

	-------------------------------------------
	--- Hellfire Citadel: The Blood Furnace ---
	-------------------------------------------

    HCFurnaceMaker = {
        { 24388, "INV_Belt_11", "=q3=Girdle of the Gale Storm", "=ds=#s10#, #a3#", "15.84%" },
        { 24387, "INV_Gauntlets_03", "=q3=Ironblade Gauntlets", "=ds=#s9#, #a4#", "13.27%" },
        { 24385, "INV_Jewelry_Necklace_17", "=q3=Pendant of Battle-Lust", "=ds=#s2#", "15.43%" },
        { 24386, "INV_Misc_Book_13", "=q3=Libram of Saints Departed", "=ds=#s16#, #w16#", "14.78%" },
        { 24384, "INV_Mace_2H_Blacksmithing_03", "=q3=Diamond-Core Sledgemace", "=ds=#h3#, #w6#", "12.90%" },
	};

    HCFurnaceMakerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30601, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Beaming Fire Opal", "=ds=#e7#", "18.18%" },
        { 30600, "INV_Jewelcrafting_Nightseye_03", "=q4=Fluorescent Tanzanite", "=ds=#e7#", "9.85%" },
        { 30602, "INV_Jewelcrafting_Talasite_03", "=q4=Jagged Chrysoprase", "=ds=#e7#", "12.12%" }, 
        { 0,"","","" },
        { 27485, "INV_Misc_Cape_18", "=q3=Embroidered Cape of Mysteries", "=ds=#s4#", "13.89%" },
        { 27488, "INV_Helmet_34", "=q3=Mage-Collar of the Firestorm", "=ds=#s1#, #a1#", "16.67%" },
        { 27483, "INV_Bracer_08", "=q3=Moon-Touched Bands", "=ds=#s8#, #a2#", "25.00%" },
        { 27487, "INV_Pants_Plate_02", "=q3=Bloodlord Legplates", "=ds=#s11#, #a4#", "9.26%" },
        { 27484, "INV_Misc_StoneTablet_05", "=q3=Libram of Avengement", "=ds=#s16#, #w16#", "14.81%" },
	};
        
    HCFurnaceBroggok = {
        { 24392, "INV_Jewelry_Ring_35", "=q3=Arcing Bracers", "=ds=#s8#, #a1#", "14.37%" },
        { 24393, "INV_Misc_SurgeonGlove_01", "=q3=Bloody Surgeon's Mitts", "=ds=#s9#, #a1#", "17.62%" },
        { 24391, "INV_Pants_Leather_03", "=q3=Kilt of the Night Strider", "=ds=#s11#, #a2#", "16.58%" },
        { 24390, "INV_Qiraj_JewelEncased", "=q3=Auslese's Light Channeler", "=ds=#s14#", "11.57%" },
        { 24389, "INV_Weapon_Rifle_17", "=q3=Legion Blunderbuss", "=ds=#w5#", "17.69%" },
	};

    HCFurnaceBroggokHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30601, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Beaming Fire Opal", "=ds=#e7#", "18.18%" },
        { 30600, "INV_Jewelcrafting_Nightseye_03", "=q4=Fluorescent Tanzanite", "=ds=#e7#", "9.85%" },
        { 30602, "INV_Jewelcrafting_Talasite_03", "=q4=Jagged Chrysoprase", "=ds=#e7#", "12.12%" }, 
        { 0,"","","" },
        { 27848, "INV_Boots_Cloth_06", "=q3=Embroidered Spellpyre Boots", "=ds=#s12#, #a1#", "8.33%" },
        { 27492, "INV_Pants_Cloth_12", "=q3=Moonchild Leggings", "=ds=#s11#, #a2#", "13.89%" },
        { 27489, "INV_Bracer_13", "=q3=Virtue Bearer's Vambraces", "=ds=#s8#, #a4#", "22.22%" },
        { 27491, "INV_Jewelry_Ring_59", "=q3=Signet of Repose", "=ds=#s13#", "30.56%" },
        { 27490, "INV_Axe_65", "=q3=Firebrand Battlexe", "=ds=#h1#, #w1#", "9.72%" },
	};
        
    HCFurnaceBreaker = {
        { 24397, "INV_Chest_Cloth_31", "=q3=Raiments of Divine Authority", "=ds=#s5#, #a1#", "16.92%" },
        { 24395, "INV_Belt_10", "=q3=Mindfire Waistband", "=ds=#s10#, #a1#", "16.64%" },
        { 24398, "INV_Shoulder_12", "=q3=Mantle of the Dusk-Dweller", "=ds=#s3#, #a2#", "14.29%" },
        { 24396, "INV_Chest_Leather_03", "=q3=Vest of Vengeance", "=ds=#s5#, #a2#", "15.46%" },
        { 24394, "INV_Axe_61", "=q3=Warsong Howling Axe", "=ds=#h2#, #w1#", "15.52%" },
	};

    HCFurnaceBreakerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 32080, "Inv_Shoulder_25", "=q4=Mantle of Shadowy Embrace", "=ds=#s3#, #a2#" },
        { 29245, "INV_Boots_Chain_06", "=q4=Wave-Crest Striders", "=ds=#s12#, #a3#", "3.79%" },
        { 29239, "INV_Boots_Plate_01", "=q4=Eaglecrest Warboots", "=ds=#s12#, #a4#", "6.82%" },
        { 29347, "Ability_Hunter_MasterMarksman", "=q4=Talisman of the Breaker", "=ds=#s2#", "7.58%" },
        { 0,"","","" },
        { 27506, "INV_Chest_Cloth_38", "=q3=Robe of Effervescent Light", "=ds=#s5#, #a1#", "17.42%" },
        { 27514, "INV_Pants_Leather_12", "=q3=Leggings of the Unrepentant", "=ds=#s12#, #a2#", "13.64%" },
        { 27522, "INV_Bracer_09", "=q3=World's End Bracers", "=ds=#s8#, #a3#", "25.76%" },
        { 27494, "INV_Bracer_16", "=q3=Emerald Eye Bracer", "=ds=#s8#, #a3#", "11.50%" },
        { 27505, "INV_Helmet_12", "=q3=Ruby Helm of the Just", "=ds=#s1#, #a4#", "11.36%" },
        { 27495, "INV_Jewelry_Necklace_39", "=q3=Soldier's Dog Tags", "=ds=#s2#", "9.85%" },
        { 28121, "INV_BRD_Banner", "=q3=Icon of Unyielding Courage", "=ds=#s14#", "8.33%" },
        { 27512, "INV_Sword_01", "=q3=The Willbreaker", "=ds=#h3#, #w10#", "6.06%" },
        { 27507, "INV_Weapon_Crossbow_15", "=q3=Adamantine Repeater", "=ds=#w3#", "6.82%" },
        { 30601, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Beaming Fire Opal", "=ds=#e7#", "18.18%" },
        { 30600, "INV_Jewelcrafting_Nightseye_03", "=q4=Fluorescent Tanzanite", "=ds=#e7#", "9.85%" },
        { 30602, "INV_Jewelcrafting_Talasite_03", "=q4=Jagged Chrysoprase", "=ds=#e7#", "12.12%" }, 
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28264, "INV_Chest_Chain_17", "=q3=Wastewalker Tunic", "=ds=#s5#, #a2# (D3)", "6.82%" },
        { 27497, "INV_Gauntlets_29", "=q3=Doomplate Gauntlets", "=ds=#s9#, #a4# (D3)", "9.09%" },
	};
        
	------------------------------------------
	--- Coilfang Reservoir: The Slave Pens ---
	------------------------------------------

    CFRSlaveMennu = {
        { 24359, "INV_Pants_Cloth_16", "=q3=Princely Reign Leggings", "=ds=#s11#, #a1#", "10.20%" },
        { 24357, "INV_Chest_Cloth_06", "=q3=Vest of Living Lightning", "=ds=#s5#, #a3#", "11.94%" },
        { 24360, "INV_Belt_11", "=q3=Tracker's Belt", "=ds=#s10#, #a3#", "11.07%" },
        { 24356, "INV_Weapon_Shortblade_33", "=q3=Wastewalker Shiv", "=ds=#h3#, #w4#", "12.47%" },
        { 24361, "INV_Sword_05", "=q3=Spellfire Longsword", "=ds=#h3#, #w10#", "11.07%" },
        { 0,"","","" },
        { 29674, "INV_Scroll_06", "=q2=Pattern: Nature Armor Kit", "=ds=#p7# (340)", "0.80%" },
	};

    CFRSlaveMennuHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30604, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Resplendent Fire Opal", "=ds=#e7#", "22.49%" },
        { 30605, "INV_Jewelcrafting_Talasite_03", "=q4=Vivid Chrysoprase", "=ds=#e7#", "9.39%" },
        { 30603, "INV_Jewelcrafting_Nightseye_03", "=q4=Royal Tanzanite", "=ds=#e7#", "10.48%" },
        { 0,"","","" },
        { 27542, "INV_Belt_30", "=q3=Cord of Belief", "=ds=#s10#, #a1#", "16.50%" },
        { 27545, "INV_Pants_Mail_05", "=q3=Mennu's Scaled Leggings", "=ds=#s11#, #a2#", "8.50%" },
        { 27541, "INV_Belt_25", "=q3=Archery Belt of the Broken", "=ds=#s10#, #a3#", "12.75%" },
        { 27546, "INV_Misc_Noose_01", "=q3=Traitor's Noose", "=ds=#s2#", "13.75%" },
        { 27544, "Spell_Nature_ProtectionformNature", "=q3=Totem of Spontaneous Regrowth", "=ds=#s16#, #w15#", "12.25%" },
        { 27543, "INV_Weapon_Shortblade_37", "=q3=Starlight Dagger", "=ds=#h3#, #w4#", "20.00%" },
	};
    
    CFRSlaveRokmar = {
        { 24379, "INV_Misc_Cape_06", "=q3=Bogstrok Scale Cloak", "=ds=#s4#", "10.05%" },
        { 24376, "INV_Mushroom_06", "=q3=Runed Fungalcap", "=ds=#s14#", "11.45%" },
        { 24378, "INV_Mace_40", "=q3=Coilfang Hammer of Renewal", "=ds=#h3#, #w6#", "9.66%" },
        { 24380, "INV_Wand_04", "=q3=Calming Spore Reed", "=ds=#w12#", "10.26%" },
        { 24381, "INV_Weapon_Crossbow_11", "=q3=Coilfang Needler", "=ds=#w3#", "10.05%" },
	};

    CFRSlaveRokmarHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30604, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Resplendent Fire Opal", "=ds=#e7#", "22.49%" },
        { 30605, "INV_Jewelcrafting_Talasite_03", "=q4=Vivid Chrysoprase", "=ds=#e7#", "9.39%" },
        { 30603, "INV_Jewelcrafting_Nightseye_03", "=q4=Royal Tanzanite", "=ds=#e7#", "10.48%" },
        { 0,"","","" },
        { 27550, "INV_Misc_Cape_13", "=q3=Ironscale War Cloak", "=ds=#s4#", "11.48%" },
        { 27547, "INV_Belt_15", "=q3=Coldwhisper Cord", "=ds=#s10#, #a1#", "14.85%" },
        { 28124, "INV_Belt_15", "=q3=Liar's Cord", "=ds=#s10#, #a2#", "8.96%" },
        { 27549, "INV_Boots_Chain_08", "=q3=Wavefury Boots", "=ds=#s12#, #a3#", "9.80%" },
        { 27548, "INV_Belt_23", "=q3=Girdle of Many Blessings", "=ds=#s10#, #a4#", "14.85%" },
        { 27551, "INV_Jewelry_Talisman_12", "=q3=Skeletal Necklace of Battlerage", "=ds=#s2#", "16.25%" },
	};
        
    CFRSlaveQuagmirran = {
        { 24362, "INV_Misc_Cape_16", "=q3=Spore-Soaked Vaneer", "=ds=#s4#", "10.63%" },
        { 24365, "INV_Gauntlets_22", "=q3=Deft Handguards", "=ds=#s9#, #a2#", "10.89%" },
        { 24366, "INV_Shoulder_03", "=q3=Scorpid-Sting Mantle", "=ds=#s3#, #a3#", "11.72%" },
        { 24363, "INV_Chest_Plate03", "=q3=Unscarred Breastplate", "=ds=#s5#, #a4#", "9.54%" },
        { 24364, "INV_Pants_Mail_15", "=q3=Azureplate Greaves", "=ds=#s11#, #a4#", "9.98%" },
	};

    CFRSlaveQuagmirranHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29242, "INV_Boots_Cloth_11", "=q4=Boots of Blasphemy", "=ds=#s12#, #a1#", "10.04%" },
        { 30538, "INV_Pants_Leather_09", "=q4=Midnight Legguards", "=ds=#s11#, #a2#", "8.95%" },
        { 32078, "Inv_Shoulder_33", "=q4=Pauldrons of Wild Magic", "=ds=#s3#, #a3#" },
        { 29349, "INV_Jewelry_Necklace_06", "=q4=Adamantine Chain of the Unbroken", "=ds=#s2#", "1.53%" },
        { 0,"","","" },
        { 27712, "INV_Bracer_08", "=q3=Shackles of Quagmirran", "=ds=#s8#, #a2#" },
        { 27800, "INV_Pants_14", "=q3=Earthsoul Britches", "=ds=#s11#, #a2#", "13.76%" },
        { 28337, "INV_Chest_Plate08", "=q3=Breastplate of Righteous Fury", "=ds=#s5#, #a4#", "8.73%" },
        { 27672, "INV_Belt_26", "=q3=Girdle of the Immovable", "=ds=#s10#, #a4#", "7.64%" },
        { 27740, "INV_Jewelry_Ring_24", "=q3=Band of Ursol", "=ds=#s13#", "12.23%" },
        { 27683, "INV_Misc_Gem_Pearl_01", "=q3=Quagmirran's Eye", "=ds=#s14#", "7.86%" },
        { 27714, "INV_Offhand_OutlandRaid_03orange", "=q3=Swamplight Lantern", "=ds=#s15#", "10.92%" },
        { 27673, "Inv_Sword_27", "=q3=Phosphorescent Blade", "=ds=#h1#, #w10#" },
        { 27741, "INV_Mace_1H_Stratholme_D_01", "=q3=Bleeding Hollow Warhammer", "=ds=#h3#, #w6#", "9.83%" },
        { 30604, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Resplendent Fire Opal", "=ds=#e7#", "22.49%" },
        { 30605, "INV_Jewelcrafting_Talasite_03", "=q4=Vivid Chrysoprase", "=ds=#e7#", "9.39%" },
        { 30603, "INV_Jewelcrafting_Nightseye_03", "=q4=Royal Tanzanite", "=ds=#e7#", "10.48%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27796, "INV_Shoulder_22", "=q3=Mana-Etched Spaulders", "=ds=#s3#, #a1# (D3)", "5.24%" },
        { 27713, "INV_Shoulder_20", "=q3=Pauldrons of Desolation", "=ds=#s3#, #a3# (D3)", "10.70%" },
	};
        
	----------------------------------------
	--- Coilfang Reservoir: The Underbog ---
	----------------------------------------

    CFRUnderHungarfen = {
        { 24450, "INV_Gauntlets_14", "=q3=Manaspark Gloves", "=ds=#s9#, #a1#", "11.72%" },
        { 24452, "INV_Gauntlets_21", "=q3=Starlight Gloves", "=ds=#s9#, #a2#", "12.35%" },
        { 24451, "INV_Jewelry_Ring_AhnQiraj_01", "=q3=Lykul Bloodbands", "=ds=#s8#, #a3#", "11.75%" },
        { 24413, "Spell_Nature_AbolishMagic", "=q3=Totem of the Thunderhead", "=ds=#s16#, #w15#", "12.86%" },
        { 27631, "INV_ThrowingKnife_06", "=q3=Needle Shrike", "=ds=#w11#", "11.60%" },
	};

    CFRUnderHungarfenHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=Lambent Chrysoprase", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Splendid Fire Opal", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=Radiant Chrysoprase", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
        { 27746, "INV_Bracer_19", "=q3=Arcanium Signet Bands", "=ds=#s8#, #a1#", "8.37%" },
        { 27745, "INV_Gauntlets_11", "=q3=Hungarhide Gauntlets", "=ds=#s9#, #a3#", "13.79%" },
        { 27743, "INV_Belt_11", "=q3=Girdle of Living Flame", "=ds=#s10#, #a3#", "13.79%" },
        { 27748, "INV_Chest_Cloth_59", "=q3=Cassock of the Loyal", "=ds=#s11#, #a4#", "7.39%" },
        { 27744, "Ability_Druid_DemoralizingRoar", "=q3=Idol of Ursoc", "=ds=#s16#, #w14#", "16.26%" },
        { 27747, "INV_Weapon_Hand_11", "=q3=Boggspine Knuckles", "=ds=#h4#, #w13#", "12.81%" },
	};
        
    CFRUnderGhazan = {
        { 24459, "INV_Misc_Cape_06", "=q3=Cloak of Healing Rays", "=ds=#s4#", "14.18%" },
        { 24458, "INV_Belt_01", "=q3=Studded Girdle of Virtue", "=ds=#s10#, #a4#", "14.06%" },
        { 24460, "INV_Misc_EngGizmos_04", "=q3=Talisman of Tenacity", "=ds=#s2#", "12.99%" },
        { 24462, "INV_Jewelry_Necklace_10", "=q3=Luminous Pearls of Insight", "=ds=#s2#", "12.75%" },
        { 24461, "INV_Hammer_10", "=q3=Hatebringer", "=ds=#h2#, #w6#", "14.12%" },
	};

    CFRUnderGhazanHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=Lambent Chrysoprase", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Splendid Fire Opal", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=Radiant Chrysoprase", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
        { 27760, "INV_Belt_24", "=q3=Dunewind Sash", "=ds=#s10#, #a2#", "14.67%" },
        { 27759, "INV_Helmet_19", "=q3=Headdress of the Tides", "=ds=#s1#, #a3#", "13.33%" },
        { 27755, "INV_Belt_29", "=q3=Girdle of Gallantry", "=ds=#s10#, #a4#", "7.33%" },
        { 27758, "INV_Jewelry_Necklace_34", "=q3=Hydra-fang Necklace", "=ds=#s2#", "12.00%" },
        { 27761, "INV_jewelry_ring_AhnQiraj_01", "=q3=Ring of the Shadow Deeps", "=ds=#s13#", "18.67%" },
        { 27757, "INV_Staff_56", "=q3=Greatstaff of the Leviathan", "=ds=#w9#", "16.00%" },
	};
        
    CFRUnderSwamplord = {
        { 24454, "INV_Misc_Cape_13", "=q3=Cloak of Enduring Swiftness", "=ds=#s4#", "17.23%" },
        { 24455, "INV_Chest_Plate06", "=q3=Tunic of the Nightwatcher", "=ds=#s5#, #a2#", "14.47%" },
        { 24457, "INV_Shoulder_21", "=q3=Truth Bearer Shoulderguards", "=ds=#s3#, #a4#", "14.42%" },
        { 24456, "INV_Pants_Mail_19", "=q3=Greaves of the Iron Guardian", "=ds=#s11#, #a4#", "12.41%" },
        { 24453, "INV_Weapon_ShortBlade_27", "=q3=Zangartooth Shortblade", "=ds=#h3#, #w4#", "15.17%" },
	};

    CFRUnderSwamplordHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=Lambent Chrysoprase", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Splendid Fire Opal", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=Radiant Chrysoprase", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
        { 27764, "INV_Gauntlets_19", "=q3=Hands of the Sun", "=ds=#s9#, #a1#", "12.14%" },
        { 27763, "INV_Helmet_17", "=q3=Crown of the Forest Lord", "=ds=#s1#, #a2#", "20.00%" },
        { 27765, "INV_Bracer_07", "=q3=Armwraps of Disdain", "=ds=#s8#, #a2#", "9.29%" },
        { 27766, "INV_Jewelry_Necklace_29", "=q3=Swampstone Necklace", "=ds=#s2#", "17.14%" },
        { 27767, "INV_Axe_55", "=q3=Bogreaver", "=ds=#h1#, #w1#", "9.29%" },
	};
        
    CFRUnderStalker = {
        { 24481, "INV_Chest_Cloth_12", "=q3=Robes of the Augurer", "=ds=#s5#, #a1#", "10.55%" },
        { 24466, "INV_Pants_Mail_21", "=q3=Skulldugger's Leggings", "=ds=#s11#, #a2#", "13.23%" },
        { 24465, "INV_Chest_Chain_03", "=q3=Shamblehide Chestguard", "=ds=#s5#, #a3#", "10.95%" },
        { 24463, "INV_Shoulder_15", "=q3=Pauldrons of Brute Force", "=ds=#s3#, #a4#", "11.95%" },
        { 24464, "INV_Sword_53", "=q3=The Stalker's Fangs", "=ds=#h1#, #w4#", "14.31%" },
        { 0,"","","" },
        { 24248, "Spell_Shadow_Brainwash", "=q1=Brain of the Black Stalker", "=ds=#m3#", "100%" },
	};

    CFRUnderStalkerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29265, "INV_Boots_Chain_05", "=q4=Barkchip Boots", "=ds=#s12#, #a2#", "8.54%" },
        { 30541, "INV_Pants_Leather_03", "=q4=Stormsong Kilt", "=ds=#s11#, #a3#", "6.50%" },
        { 32081, "INV_Jewelry_Ring_45", "=q4=Eye of the Stalker", "=ds=#s13#" },
        { 29350, "INV_Wand_1H_Stratholme_D_01", "=q4=The Black Stalk", "=ds=#w12#", "4.88%" },
        { 0,"","","" },
        { 27781, "INV_Helmet_72", "=q3=Demonfang Ritual Helm", "=ds=#s1#, #a1#", "8.94%" },
        { 27768, "INV_Belt_01", "=q3=Oracle Belt of Timeless Mystery", "=ds=#s10#, #a1#", "14.63%" },
        { 27938, "INV_Helmet_73", "=q3=Savage Mask of the Lynx Lord", "=ds=#s1#, #a2#", "1.63%" },
        { 27773, "INV_Pants_Leather_06", "=q3=Barbaric Legstraps", "=ds=#s11#, #a3#", "9.35%" },
        { 27779, "INV_Jewelry_Necklace_04", "=q3=Bone Chain Necklace", "=ds=#s2#", "14.23%" },
        { 27896, "INV_Potion_130", "=q3=Alembic of Infernal Power", "=ds=#s14#", "12.60%" },
        { 27770, "INV_Misc_ArmorKit_22", "=q3=Argussian Compass", "=ds=#s14#", "3.66%" },
        { 27769, "INV_Sword_71", "=q3=Endbringer", "=ds=#h2#, #w10#", "9.35%" },
        { 27772, "INV_Shield_34", "=q3=Stormshield of Renewal", "=ds=#w8#", "13.01%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=Lambent Chrysoprase", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Splendid Fire Opal", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=Radiant Chrysoprase", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27907, "INV_Pants_Cloth_17", "=q3=Mana-Etched Pantaloons", "=ds=#s11#, #a1# (D3)", "4.88%" },
        { 27771, "INV_Shoulder_26", "=q3=Doomplate Shoulderguards", "=ds=#s3#, #a4# (D3)", "6.50%" },
	};
       
	------------------------------
	--- Auchindoun: Mana-Tombs ---
	------------------------------
 
    AuchManaPandemonius = {
        { 25941, "INV_Boots_Chain_03", "=q3=Boots of the Outlander", "=ds=#s12#, #a3#", "10.55%" },
        { 25942, "INV_Gauntlets_30", "=q3=Faith Bearer's Gauntlets", "=ds=#s9#, #a4#", "11.41%" },
        { 25940, "INV_Relics_IdolofFerocity", "=q3=Idol of the Claw", "=ds=#s16#, #w14#", "12.18%" },
        { 25943, "INV_Weapon_ShortBlade_16", "=q3=Creepjacker", "=ds=#h3#, #w13#", "14.22%" },
        { 28166, "INV_Shield_13", "=q3=Shield of the Void", "=ds=#w8#", "10.81%" },
        { 25939, "INV_Wand_06", "=q3=Voidfire Wand", "=ds=#w12#", "13.04%" },
	};

    AuchManaPandemoniusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Enscribed Fire Opal", "=ds=#e7#", "0.08%" },
        { 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glistening Fire Opal", "=ds=#e7#", "6.06%" },
        { 30583, "INV_Jewelcrafting_Talasite_03", "=q4=Timeless Chrysoprase", "=ds=#e7#", "9.09%" },
        { 0,"","","" },
        { 27816, "INV_Shoulder_23", "=q3=Mindrage Pauldrons", "=ds=#s3#, #a1#", "13.95%" },
        { 27818, "INV_Chest_Cloth_08", "=q3=Starry Robes of the Crescent", "=ds=#s5#, #a2#", "11.63%" },
        { 27813, "INV_Boots_Chain_11", "=q3=Boots of the Colossus", "=ds=#s12#, #a4#", "13.95%" },
        { 27815, "Spell_unused", "=q3=Totem of the Astral Winds", "=ds=#s16#, #w15#", "2.33%" },
        { 27814, "INV_Weapon_Shortblade_30", "=q3=Twinblade of Mastery", "=ds=#h1#, #w4#", "6.98%" },
        { 27817, "INV_Weapon_Bow_06", "=q3=Starbolt Longbow", "=ds=#w2#", "9.30%" },
	};
        
    AuchManaTavarok = {
        { 25945, "INV_Misc_Cape_17", "=q3=Cloak of Revival", "=ds=#s4#", "8.08%" },
        { 25946, "INV_Boots_Chain_06", "=q3=Nethershade Boots", "=ds=#s12#, #a2#", "11.62%" },
        { 25947, "INV_Shoulder_17", "=q3=Lightning-Rod Pauldrons", "=ds=#s3#, #a3#", "11.25%" },
        { 25952, "INV_Sword_09", "=q3=Scimitar of the Nexus-Stalkers", "=ds=#h1#, #w10#", "12.12%" },
        { 25944, "INV_Sword_82", "=q3=Shaarde the Greater", "=ds=#h2#, #w10#", "9.35%" },
        { 25950, "INV_Staff_13", "=q3=Staff of Polarities", "=ds=#w9#", "9.91%" },
	};

    AuchManaTavarokHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Enscribed Fire Opal", "=ds=#e7#", "0.08%" },
        { 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glistening Fire Opal", "=ds=#e7#", "6.06%" },
        { 30583, "INV_Jewelcrafting_Talasite_03", "=q4=Timeless Chrysoprase", "=ds=#e7#", "9.09%" },
        { 0,"","","" },
        { 27824, "INV_Chest_Cloth_38", "=q3=Robe of the Great Dark Beyond", "=ds=#s5#, #a1#", "9.09%" },
        { 27821, "INV_Boots_Cloth_12", "=q3=Extravagant Boots of Malice", "=ds=#s12#, #a1#", "9.09%" },
        { 27825, "INV_Gauntlets_15", "=q3=Predatory Gloves", "=ds=#s9#, #a2#", "15.15%" },
        { 27826, "INV_Shoulder_33", "=q3=Mantle of the Sea Wolf", "=ds=#s3#, #a3#", "3.03%" },
        { 27823, "INV_Chest_Chain_13", "=q3=Shard Encrusted Breastplate", "=ds=#s5#, #a3#", "15.15%" },
        { 27822, "INV_Jewelry_Ring_54", "=q3=Crystal Band of Valor", "=ds=#s13#", "15.15%" },
	};

    AuchManaNexusPrince = {
        { 25957, "INV_Boots_Cloth_02", "=q3=Ethereal Boots of the Skystrider", "=ds=#s12#, #a1#", "11.60%" },
        { 25955, "INV_Helmet_57", "=q3=Mask of the Howling Storm", "=ds=#s1#, #a3#", "12.37%" },
        { 25956, "INV_Bracer_05", "=q3=Nexus-Bracers of Vigor", "=ds=#s8#, #a4#", "10.84%" },
        { 25954, "INV_SummerFest_Symbol_High", "=q3=Sigil of Shaffar", "=ds=#s2#", "12.45%" },
        { 25962, "INV_Jewelry_Ring_44", "=q3=Longstrider's Loop", "=ds=#s13#", "12.32%" },
        { 25953, "INV_Weapon_Bow_20", "=q3=Ethereal Warp-Bow", "=ds=#w2#", "14.19%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 22921, "INV_Scroll_06", "=q2=Recipe: Major Frost Protection Potion", "=ds=#p1# (360)", "0.85%" },
        { 0,"","","" },
        { 28490, "INV_Misc_Bandage_Netherweave", "=q1=Shaffar's Wrappings", "=ds=#m3#", "100%" },
	};

    AuchManaNexusPrinceHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29240, "INV_Bracer_12", "=q4=Bands of Negation", "=ds=#s8#, #a1#", "3.03%" },
        { 30535, "INV_Pants_Mail_08", "=q4=Forestwalker Kilt", "=ds=#s11#, #a2#", "27.27%" },
        { 29252, "INV_Bracer_02", "=q4=Bracers of Dignity", "=ds=#s8#, #a4#", "3.03%" },
        { 29352, "INV_Jewelry_Ring_57", "=q4=Cobalt Band of Tyrigosa", "=ds=#s13#", "0.21%" },
        { 32082, "Inv_Shield_01", "=q4=The Fel Barrier", "=ds=#w8#" },
        { 0,"","","" },
        { 27843, "INV_Belt_10", "=q3=Glyph-Lined Sash", "=ds=#s10#, #a1#", "10.80%" },
        { 27835, "INV_Belt_03", "=q3=Stillwater Girdle", "=ds=#s10#, #a3#", "6.06%" },
        { 27844, "INV_Shoulder_35", "=q3=Pauldrons of Swift Retribution", "=ds=#s3#, #a4#", "8.10%" },
        { 27798, "INV_Gauntlets_19", "=q3=Gauntlets of Vindication", "=ds=#s9#, #a4#", "11.80%" },
        { 0,"","","" },
        { 22921, "INV_Scroll_06", "=q2=Recipe: Major Frost Protection Potion", "=ds=#p1# (360)", "2.85%" },
        { 0,"","","" },
        { 0,"","","" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Enscribed Fire Opal", "=ds=#e7#", "0.08%" },
        { 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glistening Fire Opal", "=ds=#e7#", "6.06%" },
        { 30583, "INV_Jewelcrafting_Talasite_03", "=q4=Timeless Chrysoprase", "=ds=#e7#", "9.09%" },
        { 0,"","","" },
        { 27837, "INV_Pants_Mail_04", "=q3=Wastewalker Leggings", "=ds=#s11#, #a2# (D3)", "3.03%" },
        { 0,"","","" },
        { 27828, "INV_Scarab_Crystal", "=q3=Warp-Scarab Brooch", "=ds=#s14#", "30.30%" },
        { 28400, "INV_Sword_51", "=q3=Warp-Storm Warblade", "=ds=#h1#, #w10#" },
        { 27829, "INV_Axe_70", "=q3=Axe of the Nexus-Kings", "=ds=#h2#, #w1#", "9.09%" },
        { 27840, "INV_Mace_51", "=q3=Scepter of Sha'tar", "=ds=#h2#, #w6#" },
        { 27842, "INV_Staff_45", "=q3=Grand Scepter of the Nexus-Kings", "=ds=#w9#", "9.09%" },
	};

    AuchManaYor = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 31919, "Inv_Jewelry_Ring_53Naxxramas", "=q4=Nexus-Prince's Ring of Balance", "=ds=#s13#" },
        { 31920, "Inv_Jewelry_Ring_51Naxxramas", "=q4=Shaffar's Band of Brutality", "=ds=#s13#" },
        { 31921, "Inv_Jewelry_Ring_48Naxxramas", "=q4=Yor's Collapsing Band", "=ds=#s13#" },
        { 31922, "Inv_Jewelry_Ring_49Naxxramas", "=q4=Ring of Conflict Survival", "=ds=#s13#" },
        { 31923, "Inv_Jewelry_Ring_52Naxxramas", "=q4=Band of the Crystalline Void", "=ds=#s13#" },
        { 31924, "Inv_Jewelry_Ring_50Naxxramas", "=q4=Yor's Revenge", "=ds=#s13#" },
        { 0,"","","" },
        { 31554, "INV_Chest_Cloth_08", "=q3=Windchanneller's Tunic", "=ds=#s5#, #a1# =q2=#m16#" },
        { 31562, "INV_Chest_Leather_07", "=q3=Skystalker's Tunic", "=ds=#s5#, #a2# =q2=#m16#" },
        { 31570, "INV_Chest_Chain_17", "=q3=Mistshroud Tunic", "=ds=#s5#, #a3# =q2=#m16#" },
        { 31578, "INV_Chest_Plate14", "=q3=Slatesteel Breastplate", "=ds=#s5# #a4#, =q2=#m16#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Enscribed Fire Opal", "=ds=#e7#", "0.08%" },
        { 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glistening Fire Opal", "=ds=#e7#", "6.06%" },
        { 30583, "INV_Jewelcrafting_Talasite_03", "=q4=Timeless Chrysoprase", "=ds=#e7#", "9.09%" },
	};

    AuchManaTrash = {
        { 23615, "INV_Scroll_05", "=q3=Plans: Swiftsteel Gloves", "=ds=#p2# (370), =q1=#n54#", "0.52%" },
        { 0,"","","" },
        { 22543, "INV_Misc_Note_01", "=q2=Formula: Enchant Boots - Fortitude", "=ds=#p4# (320) =q1=#n83#", "0.52%" },
	};

	-----------------------------------
	--- Auchindoun: Auchenai Crypts ---
	-----------------------------------

    AuchCryptsShirrak = {
        { 27410, "INV_Helmet_06", "=q3=Collar of Command", "=ds=#s1#, #a1#", "13.00%" },
        { 27409, "INV_Helmet_21", "=q3=Raven-Heart Headdress", "=ds=#s1#, #a2#", "11.18%" },
        { 27408, "INV_Helmet_16", "=q3=Hope Bearer Helm", "=ds=#s1#, #a4#", "15.16%" },
        { 26055, "INV_Jewelry_Ring_45", "=q3=Oculus of the Hidden Eye", "=ds=#s14#", "15.16%" },
        { 25964, "INV_Sword_78", "=q3=Shaarde the Lesser", "=ds=#h3#, #w10#", "11.59%" },
	};

    AuchCryptsShirrakHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30587, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Champion's Fire Opal", "=ds=#e7#", "11.67%" },
        { 30588, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Potent Fire Opal", "=ds=#e7#", "1.67%" },
        { 30586, "INV_Jewelcrafting_Talasite_03", "=q4=Seer's Chrysoprase", "=ds=#e7#", "11.67%" },
        { 0,"","","" },
        { 27866, "INV_Helmet_52", "=q3=Scintillating Headdress of Second Sight", "=ds=#s1#, #a1#", "15.00%" },
        { 27493, "INV_Gauntlets_19", "=q3=Gloves of the Deadwatcher", "=ds=#s9#, #a1#", "10.87%" },
        { 27865, "INV_Bracer_16", "=q3=Bracers of Shirrak", "=ds=#s8#, #a3#", "21.74%" },
        { 27845, "INV_Boots_Chain_13", "=q3=Magma Plume Boots", "=ds=#s12#, #a3#", "23.91%" },
        { 27847, "INV_Shoulder_34", "=q3=Fanblade Pauldrons", "=ds=#s3#, #a4#", "6.52%" },
        { 27846, "INV_Weapon_Hand_07", "=q3=Claw of the Watcher", "=ds=#h3#, #w13#", "6.52%" },
	};

    AuchCryptsExarch = {
        { 27411, "INV_Boots_Cloth_14", "=q3=Slippers of Serenity", "=ds=#s12#, #a1#", "8.14%" },
        { 27415, "INV_Helmet_42", "=q3=Darkguard Face Mask", "=ds=#s1#, #a2#", "11.44%" },
        { 27414, "INV_Helmet_19", "=q3=Mok'Nathal Beast-Mask", "=ds=#s1#, #a3#", "11.27%" },
        { 27413, "INV_Jewelry_Ring_34", "=q3=Ring of the Exarchs", "=ds=#s13#", "10.42%" },
        { 27416, "INV_Helmet_45", "=q3=Fetish of the Fallen", "=ds=#s14#", "12.81%" },
        { 27412, "INV_Staff_32", "=q3=Ironstaff of Regeneration", "=ds=#w9#", "11.95%" },
	};

    AuchCryptsExarchHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29354, "INV_Misc_Cape_06", "=q4=Light-Touched Stole of Altruism", "=ds=#s4#", "6.67%" },
        { 29257, "INV_Belt_03", "=q4=Sash of Arcane Visions", "=ds=#s10#, #a1#", "6.67%" },
        { 29244, "INV_Belt_22", "=q4=Wave-Song Girdle", "=ds=#s10#, #a3#", "20.00%" },
        { 0,"","","" },
        { 27867, "INV_Boots_Chain_06", "=q3=Boots of the Unjust", "=ds=#s12#, #a2#", "3.33%" },
        { 27871, "Spell_Holy_SummonLightwell", "=q3=Maladaar's Blessed Chaplet", "=ds=#s2#", "18.33%" },
        { 27869, "INV_Jewelry_Ring_38", "=q3=Soulpriest's Ring of Resolve", "=ds=#s13#", "18.33%" },
        { 27523, "INV_Jewelry_Ring_55", "=q3=Exarch's Diamond Band", "=ds=#s13#", "13.33%" },
        { 27872, "INV_Axe_62", "=q3=The Harvester of Souls", "=ds=#h1#, #w1#", "11.67%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30587, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Champion's Fire Opal", "=ds=#e7#", "11.67%" },
        { 30588, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Potent Fire Opal", "=ds=#e7#", "1.67%" },
        { 30586, "INV_Jewelcrafting_Talasite_03", "=q4=Seer's Chrysoprase", "=ds=#e7#", "11.67%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27870, "INV_Pants_Plate_12", "=q3=Doomplate Legguards", "=ds=#s11#, #a4# (D3)", "3.33%" },
	};

    AuchCryptsAvatar = {
        { 27878, "INV_Misc_Cape_21", "=q3=Auchenai Death Shroud", "=ds=#s4#", "4.41%" },
        { 28268, "INV_Gauntlets_21", "=q3=Natural Mender's Wraps", "=ds=#s9#, #a2#", "3.94%" },
        { 27876, "INV_Mace_08", "=q3=Will of the Fallen Exarch", "=ds=#h3#, #w6#", "5.10%" },
        { 27937, "INV_Mace_34", "=q3=Sky Breaker", "=ds=#h3#, #w6#", "3.48%" },
        { 27877, "INV_Staff_42", "=q3=Draenic Wildstaff", "=ds=#w9#", "4.87%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27797, "INV_Shoulder_15", "=q3=Wastewalker Shoulderpads", "=ds=#s3#, #a2# (D3)", "3.94%" },
	};

    AuchCryptsTrash = {
        { 23605, "INV_Scroll_05", "=q3=Plans: Felsteel Gloves", "=ds=#p2# (370), =q1=#n55#", "0.69%" },
        { 0,"","","" },
        { 22544, "INV_Misc_Note_01", "=q2=Formula: Enchant Boots - Dexterity", "=ds=#p4# (340) =q1=#n82#", "0.60%" },
	};

	---------------------------------
	--- Auchindoun: Sethekk Halls ---
	---------------------------------

    AuchSethekkDarkweaver = {
        { 27919, "INV_Boots_Cloth_02", "=q3=Light-Woven Slippers", "=ds=#s12#, #a1#", "13.90%" },
        { 27914, "INV_Boots_Cloth_14", "=q3=Moonstrider Boots", "=ds=#s12#, #a2#", "12.26%" },
        { 27915, "INV_Boots_Chain_05", "=q3=Sky-Hunter Swift Boots", "=ds=#s12#, #a3#", "11.74%" },
        { 27918, "INV_Bracer_10", "=q3=Bands of Syth", "=ds=#s8#, #a4#", "11.81%" },
        { 27917, "INV_Relics_LibramofTruth", "=q3=Libram of the Eternal Rest", "=ds=#s16#, #w16#", "14.12%" },
        { 27916, "INV_ThrowingKnife_06", "=q3=Sethekk Feather-Darts", "=ds=#w11#", "11.34%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 24160, "INV_Scroll_05", "=q3=Design: Khorium Inferno Band", "=ds=#p12# (355)", "0.29%" },
        { 0,"","","" },
        { 27633, "Inv_Helm_Mask_ZulGurub_D_01", "=q1=Terokk's Mask", "=ds=#m3#", "100%" },
	};

    AuchSethekkDarkweaverHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30553, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Pristine Fire Opal", "=ds=#e7#", "15.73%" },
        { 30554, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Stalwart Fire Opal", "=ds=#e7#", "10.11%" },
        { 30552, "INV_Jewelcrafting_Nightseye_03", "=q4=Blessed Tanzanite", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 27919, "INV_Boots_Cloth_02", "=q3=Light-Woven Slippers", "=ds=#s12#, #a1#", "6.32%" },
        { 27914, "INV_Boots_Cloth_14", "=q3=Moonstrider Boots", "=ds=#s12#, #a2#", "17.89%" },
        { 27915, "INV_Boots_Chain_05", "=q3=Sky-Hunter Swift Boots", "=ds=#s12#, #a3#", "14.74%" },
        { 27918, "INV_Bracer_10", "=q3=Bands of Syth", "=ds=#s8#, #a4#", "10.53%" },
        { 27917, "INV_Relics_LibramofTruth", "=q3=Libram of the Eternal Rest", "=ds=#s16#, #w16#", "7.37%" },
        { 27916, "INV_ThrowingKnife_06", "=q3=Sethekk Feather-Darts", "=ds=#w11#", "20.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 24160, "INV_Scroll_05", "=q3=Design: Khorium Inferno Band", "=ds=#p12# (355)", "0.29%" },
        { 0,"","","" },
        { 25461, "INV_Misc_Book_06", "=q1=Book of Forgotten Names", "=ds=#m3#", "100%" },
	};
        
    AuchSethekkTheSagaofTerokk ={
        { 27634, "INV_Relics_LibramofTruth", "=q1=The Saga of Terokk", "=ds=#m3#" },
	};

    AuchSethekkTalonKing = {
        { 27946, "INV_Misc_Cape_16", "=q3=Avian Cloak of Feathers", "=ds=#s4#", "10.21%" },
        { 27981, "INV_Misc_Cape_11", "=q3=Sethekk Oracle Cloak", "=ds=#s4#", "10.00%" },
        { 27985, "INV_Belt_23", "=q3=Deathforge Girdle", "=ds=#s10#, #a4#", "9.24%" },
        { 27925, "INV_Jewelry_Ring_16", "=q3=Ravenclaw Band", "=ds=#s13#", "12.79%" },
        { 27980, "INV_Hammer_19", "=q3=Terokk's Nightmace", "=ds=#h1#, #w6#", "11.18%" },
        { 27986, "INV_Axe_69", "=q3=Crow Wing Reaper", "=ds=#h2#, #w1#", "8.50%" },
        { 0,"","","" },
        { 27632, "INV_Spear_11", "=q1=Terokk's Quill", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27948, "INV_Pants_08", "=q3=Trousers of Oblivion", "=ds=#s11#, #a1# (D3)", "8.89%" },
        { 27838, "INV_Pants_Cloth_20", "=q3=Incanter's Trousers", "=ds=#s11#, #a1# (D3)", "9.54%" },
        { 27875, "INV_Pants_Cloth_18", "=q3=Hallowed Trousers", "=ds=#s11#, #a1# (D3)", "10.28%" },
        { 27776, "INV_Shoulder_24", "=q3=Shoulderpads of Assassination", "#s3#, #a2# (D3)", "10.21%" },
        { 27936, "INV_Pants_Cloth_20", "=q3=Greaves of Desolation", "=ds=#s11#, #a3# (D3)", "12.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27991, "INV_Misc_Key_02", "=q1=Shadow Labyrinth Key", "=ds=#e9#", "100%" },
	};

    AuchSethekkTalonKingHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29249, "INV_Bracer_13", "=q4=Bands of the Benevolent", "=ds=#s8#, #a1#", "4.49%" },
        { 29259, "INV_Bracer_02", "=q4=Bracers of the Hunt", "=ds=#s8#, #a3#", "7.87%" },
        { 32073, "Inv_Shoulder_16", "=q4=Spaulders of Dementia", "=ds=#s3#, #a4#" },
        { 29355, "INV_Weapon_Halberd19", "=q4=Terokk's Shadowstaff", "=ds=#w9#", "0.16%" },
        { 0,"","","" },
        { 27946, "INV_Misc_Cape_16", "=q3=Avian Cloak of Feathers", "=ds=#s4#", "5.62%" },
        { 27981, "INV_Misc_Cape_11", "=q3=Sethekk Oracle Cloak", "=ds=#s4#", "5.62%" },
        { 27985, "INV_Belt_23", "=q3=Deathforge Girdle", "=ds=#s10#, #a4#", "3.37%" },
        { 27925, "INV_Jewelry_Ring_16", "=q3=Ravenclaw Band", "=ds=#s13#", "11.24%" },
        { 27980, "INV_Hammer_19", "=q3=Terokk's Nightmace", "=ds=#h1#, #w6#", "5.62%" },
        { 27986, "INV_Axe_69", "=q3=Crow Wing Reaper", "=ds=#h2#, #w1#", "16.85%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30553, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Pristine Fire Opal", "=ds=#e7#", "15.73%" },
        { 30554, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Stalwart Fire Opal", "=ds=#e7#", "10.11%" },
        { 30552, "INV_Jewelcrafting_Nightseye_03", "=q4=Blessed Tanzanite", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27948, "INV_Pants_08", "=q3=Trousers of Oblivion", "=ds=#s11#, #a1# (D3)", "8.99%" },
        { 27838, "INV_Pants_Cloth_20", "=q3=Incanter's Trousers", "=ds=#s11#, #a1# (D3)", "12.36%" },
        { 27875, "INV_Pants_Cloth_18", "=q3=Hallowed Trousers", "=ds=#s11#, #a1# (D3)", "15.73%" },
        { 27776, "INV_Shoulder_24", "=q3=Shoulderpads of Assassination", "#s3#, #a2# (D3)", "4.49%" },
        { 27936, "INV_Pants_Cloth_20", "=q3=Greaves of Desolation", "=ds=#s11#, #a3# (D3)", "19.10%" },
	};

    AuchSethekkRavenGod = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 32768, "INV-mount_Raven_54", "=q4=Reins of the Raven Lord", "=ds=#e12#" },
        { 30553, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Pristine Fire Opal", "=ds=#e7#", "15.73%" },
        { 30554, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Stalwart Fire Opal", "=ds=#e7#", "10.11%" },
        { 30552, "INV_Jewelcrafting_Nightseye_03", "=q4=Blessed Tanzanite", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 32769, "Inv_Belt_19", "=q3=Belt of the Raven Lord", "=ds=#s10#, #a2#" },
        { 32778, "Inv_Boots_Plate_06", "=q3=Boots of Righteous Fortitude", "=ds=#s12#, #a4#" },
        { 32779, "Inv_Jewelry_Ring_63", "=q3=Band of Frigid Elements", "=ds=#s13#" },
        { 32781, "Inv_Weapon_Shortblade_16", "=q3=Talon of Anzu", "=ds=#h3#, #w4#" },
        { 32780, "Inv_Weapon_Rifle_22", "=q3=The Boomstick", "=ds=#w5#" },
	};

    AuchSethekkTrash = {
        { 25731, "INV_Scroll_05", "=q3=Pattern: Stylin' Crimson Hat", "=ds=#p7# (350) =q1=#n84#", "0.46%" },
        { 0,"","","" },
        { 29669, "INV_Scroll_06", "=q2=Pattern: Shadow Armor Kit", "=ds=#p7# (340) =q1=#n85#", "0.39%" },
	};

	------------------------------------------------
	--- Caverns of Time: Old Hillsbrad Foothills ---
	------------------------------------------------

    CoTHillsbradDrake = {
        { 27423, "INV_Misc_Cape_18", "=q3=Cloak of Impulsiveness", "=ds=#s4#", "19.68%" },
        { 27418, "INV_Pants_Leather_12", "=q3=Stormreaver Shadow-Kilt", "=ds=#s11#, #a1#", "18.16%" },
        { 27417, "INV_Shoulder_17", "=q3=Ravenwing Pauldrons", "=ds=#s3#, #a2#", "18.33%" },
        { 27420, "INV_Boots_Plate_02", "=q3=Uther's Ceremonial Warboots", "=ds=#s12#, #a4#", "17.14%" },
        { 27436, "INV_Jewelry_Ring_30", "=q3=Iron Band of the Unbreakable", "=ds=#s13#", "15.09%" },
	};

    CoTHillsbradDrakeHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30589, "INV_Jewelcrafting_Talasite_03", "=q4=Dazzling Chrysoprase", "=ds=#e7#", "0.66%" },
        { 30591, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Empowered Fire Opal", "=ds=#e7#", "0.24%" },
        { 30590, "INV_Jewelcrafting_Talasite_03", "=q4=Enduring Chrysoprase", "=ds=#e7#", "0.10%" },
        { 0,"","","" },
        { 28212, "INV_Pants_Cloth_14", "=q3=Aran's Sorcerous Slacks", "=ds=#s11#, #a1#", "11.43%" },
        { 28214, "INV_Gauntlets_07", "=q3=Grips of the Lunar Eclipse", "=ds=#s9#, #a2#", "2.86%" },
        { 28215, "INV_Helmet_72", "=q3=Mok'Nathal Mask of Battle", "=ds=#s1#, #a3#", "11.43%" },
        { 28211, "INV_Jewelry_Ring_10", "=q3=Lieutenant's Signet of Lordaeron", "=ds=#s13#", "5.71%" },
        { 28213, "INV_Misc_Book_10", "=q3=Lordaeron Medical Guide", "=ds=#s15#", "8.57%" },
        { 28210, "INV_Mace_44", "=q3=Bloodskull Destroyer", "=ds=#h1#, #w6#", "5.71%" },
	};

    CoTHillsbradSkarloc = {
        { 27428, "INV_Gauntlets_26", "=q3=Stormfront Gauntlets", "=ds=#s9#, #a3#", "19.04%" },
        { 27430, "INV_Pants_Plate_21", "=q3=Scaled Greaves of Patience", "=ds=#s11#, #a3#", "19.22%" },
        { 27427, "INV_Chest_Chain_12", "=q3=Durotan's Battle Harness", "=ds=#s5#, #a4#", "14.83%" },
        { 27424, "INV_Axe_15", "=q3=Amani Venom Axe", "=ds=#h1#, #w1#", "18.50%" },
        { 27426, "INV_Mace_55", "=q3=Nortshire Battle Mace", "=ds=#h3#, #w6#", "15.37%" },
        { 0,"","","" },
        { 22927, "INV_Scroll_06", "=q2=Recipe: Ironshield Potion", "=ds=#p1# (365)", "1.03%" },
	};

    CoTHillsbradSkarlocHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30589, "INV_Jewelcrafting_Talasite_03", "=q4=Dazzling Chrysoprase", "=ds=#e7#", "0.66%" },
        { 30591, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Empowered Fire Opal", "=ds=#e7#", "0.24%" },
        { 30590, "INV_Jewelcrafting_Talasite_03", "=q4=Enduring Chrysoprase", "=ds=#e7#", "0.10%" },
        { 0,"","","" },
        { 28218, "INV_Pants_Cloth_18", "=q3=Pontiff's Pantaloons of Prophecy", "=ds=#s11#, #a1#", "18.18%" },
        { 28220, "INV_Helmet_24", "=q3=Moon-Crown Antlers", "=ds=#s1#, #a2#", "0.14%" },
        { 28219, "INV_Pants_Mail_16", "=q3=Emerald-Scale Greaves", "=ds=#s11#, #a3#", "3.03%" },
        { 28221, "INV_Boots_Chain_08", "=q3=Boots of the Watchful Heart", "=ds=#s12#, #a4#", "0.52%" },
        { 28217, "INV_Trinket_HonorHold", "=q3=Tarren Mill Vitality Locket", "=ds=#s2#", "9.09%" },
        { 28216, "INV_Hammer_11", "=q3=Dathrohan's Ceremonial Hammer", "=ds=#h3#, #w6#", "6.06%" },
	};

    CoTHillsbradHunter = {
        { 24173, "INV_Scroll_05", "=q4=Design: Circlet of Arcane Might", "=ds=#p12# (370)", "0.10%" },
        { 0,"","","" },
        { 27433, "INV_Shoulder_26", "=q3=Pauldrons of Sufferance", "=ds=#s3#, #a1#", "19.11%" },
        { 27434, "INV_Shoulder_35", "=q3=Mantle of Perenolde", "=ds=#s3#, #a2#", "16.26%" },
        { 27440, "INV_Misc_Gem_Diamond_01", "=q3=Diamond Prism of Recurrence", "=ds=#s2#", "16.12%" },
        { 27432, "INV_Jewelry_Ring_53Naxxramas", "=q3=Broxxigar's Ring of Valor", "=ds=#s13#", "16.35%" },
        { 27431, "INV_Weapon_Shortblade_33", "=q3=Time-Shifted Dagger", "=ds=#h3#, #w4#", "14.09%" },
	};

    CoTHillsbradHunterHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29250, "INV_Belt_15", "=q4=Cord of Sanctification", "=ds=#s10#, #a1#" },
        { 29246, "INV_Bracer_15", "=q4=Nightfall Wristguards", "=ds=#s8#, #a2#" },
        { 29357, "INV_Gauntlets_22", "=q4=Master Thief's Gloves", "=ds=#s9#, #a2#", "10.00%" },
        { 30536, "INV_Pants_Plate_21", "=q4=Greaves of the Martyr", "=ds=#s11#, #a4#", "15.00%" },
        { 0,"","","" },
        { 27911, "INV_Belt_19", "=q3=Epoch's Whispering Cinch", "=ds=#s10#, #a2#", "10.00%" },
        { 28344, "INV_Shoulder_18", "=q3=Wyrmfury Pauldrons", "=ds=#s3#, #a3#", "0.24%" },
        { 28233, "INV_Jewelry_Necklace_12", "=q3=Necklace of Resplendent Hope", "=ds=#s2#", "15.00%" },
        { 27904, "INV_Jewelry_Ring_64", "=q3=Resounding Ring of Glory", "=ds=#s13#", "0.17%" },
        { 28227, "INV_Jewelry_Ring_63", "=q3=Sparking Arcanite Ring", "=ds=#s13#", "0.24%" },
        { 28223, "INV_Jewelcrafting_Nightseye_01", "=q3=Arcanist's Stone", "=ds=#s14#", "10.00%" },
        { 28226, "INV_Weapon_Shortblade_51", "=q3=Timeslicer", "=ds=#h1#, #w4#", "5.00%" },
        { 28222, "INV_Axe_71", "=q3=Reaver of the Infinites", "=ds=#h2#, #w1#", "0.48%" },
        { 0,"","","" },
        { 30589, "INV_Jewelcrafting_Talasite_03", "=q4=Dazzling Chrysoprase", "=ds=#e7#", "0.66%" },
        { 30591, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Empowered Fire Opal", "=ds=#e7#", "0.24%" },
        { 30590, "INV_Jewelcrafting_Talasite_03", "=q4=Enduring Chrysoprase", "=ds=#e7#", "0.10%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28191, "INV_Chest_Cloth_42", "=q3=Mana-Etched Vestments", "=ds=#s5#, #a1# (D3)", "0.24%" },
        { 28224, "INV_Helmet_15", "=q3=Wastewalker Helm", "=ds=#s1#, #a2# (D3)", "0.24%" },
        { 28401, "INV_Chest_Chain_03", "=q3=Hauberk of Desolation", "=ds=#s5#, #a3# (D3)", "0.14%" },
        { 28225, "INV_Helmet_20", "=q3=Doomplate Warhelm", "=ds=#s1#, #a4# (D3)", "0.14%" },
	};

    CoTHillsbradTrash = {
        { 25729, "INV_Scroll_05", "=q3=Pattern: Stylin' Adventure Hat", "=ds=#p7# (350) =q1=#n94#", "0.25%" },
	};

	------------------------------------
	--- Auchindoun: Shadow Labyrinth ---
	------------------------------------

    AuchShadowHellmaw = {
        { 27889, "INV_Gauntlets_19", "=q3=Jaedenfire Gloves of Annihilation", "=ds=#s9#, #a1#", "13.58%" },
        { 27888, "INV_Helmet_21", "=q3=Dream-Wing Helm", "=ds=#s1#, #a3#", "11.81%" },
        { 27884, "INV_Boots_Chain_04", "=q3=Ornate Boots of the Sanctified", "=ds=#s12#, #a4#", "13.15%" },
        { 27886, "Spell_Nature_NatureResistanceTotem", "=q3=Idol of the Emerald Queen", "=ds=#s16#, #w14#", "12.94%" },
        { 27887, "INV_Shield_35", "=q3=Platinum Shield of the Valorous", "=ds=#w8#", "10.88%" },
        { 27885, "INV_Wand_05", "=q3=Soul-Wand of the Aldor", "=ds=#w12#", "13.34%" },
	};

    AuchShadowHellmawHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=Regal Tanzanite", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Etched Fire Opal", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=Rune Covered Chrysoprase", "=ds=#e7#", "15.47%" },
        { 0,"","","" },
        { 27889, "INV_Gauntlets_19", "=q3=Jaedenfire Gloves of Annihilation", "=ds=#s9#, #a1#", "14.47%" },
        { 27888, "INV_Helmet_21", "=q3=Dream-Wing Helm", "=ds=#s1#, #a3#", "10.53%" },
        { 27884, "INV_Boots_Chain_04", "=q3=Ornate Boots of the Sanctified", "=ds=#s12#, #a4#", "18.42%" },
        { 27886, "Spell_Nature_NatureResistanceTotem", "=q3=Idol of the Emerald Queen", "=ds=#s16#, #w14#", "10.53%" },
        { 27887, "INV_Shield_35", "=q3=Platinum Shield of the Valorous", "=ds=#w8#", "11.84%" },
        { 27885, "INV_Wand_05", "=q3=Soul-Wand of the Aldor", "=ds=#w12#", "10.53%" },
	};

    AuchShadowBlackheart = {
        { 27892, "INV_Misc_Cape_08", "=q3=Cloak of the Inciter", "=ds=#s4#", "16.32%" },
        { 27893, "INV_Pants_Plate_21", "=q3=Ornate Leggings of the Venerated", "=ds=#s11#, #a4#", "13.35%" },
        { 28134, "INV_Jewelry_Necklace_27", "=q3=Brooch of Hightened Potential", "=ds=#s2#", "10.54%" },
        { 27891, "INV_QirajIdol_Sage", "=q3=Adamantine Figurine", "=ds=#s14#", "10.93%" },
        { 27890, "INV_Wand_19", "=q3=Wand of the Netherwing", "=ds=#w12#", "10.77%" },
        { 0,"","","" },
        { 25728, "INV_Scroll_05", "=q3=Pattern: Stylin' Purple Hat", "=ds=#p7# (350)", "0.94%" },
        { 0,"","","" },
        { 30808, "INV_Misc_Book_06", "=q1=Book of Fel Names", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27468, "INV_Gauntlets_13", "=q3=Moonglade Handwraps", "=ds=#s9#, #a2# (D3)", "10.93%" },
	};

    AuchShadowBlackheartHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=Regal Tanzanite", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Etched Fire Opal", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=Rune Covered Chrysoprase", "=ds=#e7#", "15.47%" },
        { 0,"","","" },
        { 27892, "INV_Misc_Cape_08", "=q3=Cloak of the Inciter", "=ds=#s4#", "26.67%" },
        { 27893, "INV_Pants_Plate_21", "=q3=Ornate Leggings of the Venerated", "=ds=#s11#, #a4#", "6.67%" },
        { 28134, "INV_Jewelry_Necklace_27", "=q3=Brooch of Hightened Potential", "=ds=#s2#", "6.67%" },
        { 27891, "INV_QirajIdol_Sage", "=q3=Adamantine Figurine", "=ds=#s14#", "6.67%" },
        { 27890, "INV_Wand_19", "=q3=Wand of the Netherwing", "=ds=#w12#", "20.00%" },
        { 0,"","","" },
        { 25728, "INV_Scroll_05", "=q3=Pattern: Stylin' Purple Hat", "=ds=#p7# (350)", "0.94%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27468, "INV_Gauntlets_13", "=q3=Moonglade Handwraps", "=ds=#s9#, #a2# (D3)", "6.67%" },
	};

    AuchShadowGrandmaster = {
        { 27897, "INV_Chest_Plate11", "=q3=Breastplate of Many Graces", "=ds=#s5#, #a4#", "12.67%" },
        { 27900, "INV_Misc_Gem_LionsEye_01", "=q3=Jewel of Charismatic Mystique", "=ds=#s14#", "16.64%" },
        { 27901, "INV_Mace_35", "=q3=Blackout Truncheon", "=ds=#h1#, #w6#", "14.35%" },
        { 27898, "INV_Weapon_Rifle_20", "=q3=Wrathfire Hand-Cannon", "=ds=#w5#", "14.71%" },
        { 0,"","","" },
        { 30827, "INV_Misc_Book_01", "=q1=Lexicon Demonica", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27775, "INV_Shoulder_22", "=q3=Hallowed Pauldrons", "=ds=#s3#, #a1# (D3)", "16.11%" },
	};

    AuchShadowGrandmasterHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=Regal Tanzanite", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Etched Fire Opal", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=Rune Covered Chrysoprase", "=ds=#e7#", "15.47%" },
        { 0,"","","" },
        { 27897, "INV_Chest_Plate11", "=q3=Breastplate of Many Graces", "=ds=#s5#, #a4#", "15.79%" },
        { 27900, "INV_Misc_Gem_LionsEye_01", "=q3=Jewel of Charismatic Mystique", "=ds=#s14#", "26.32%" },
        { 27901, "INV_Mace_35", "=q3=Blackout Truncheon", "=ds=#h1#, #w6#", "5.26%" },
        { 27898, "INV_Weapon_Rifle_20", "=q3=Wrathfire Hand-Cannon", "=ds=#w5#", "8.77%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27775, "INV_Shoulder_22", "=q3=Hallowed Pauldrons", "=ds=#s3#, #a1# (D3)", "19.30%" },
	};

    AuchShadowMurmur = {
        { 24309, "INV_Scroll_05", "=q4=Pattern: Spellstrike Pants", "=ds=#p8# (375)", "0.37%" },
        { 0,"","","" },
        { 27902, "INV_Boots_Cloth_09", "=q3=Silent Slippers of Meditation", "=ds=#s12#, #a1#", "12.28%" },
        { 27912, "INV_Chest_Leather_05", "=q3=Harness of the Deep Currents", "=ds=#s5#, #a3#", "13.59%" },
        { 27913, "INV_Weapon_Shortblade_51", "=q3=Whispering Blade of Slaying", "=ds=#h1#, #w4#", "9.69%" },
        { 27905, "INV_Sword_2H_Blood_C_03", "=q3=Greatsword of Horrid Dreams", "=ds=#h3#, #w10#", "9.35%" },
        { 27903, "INV_Spear_08", "=q3=Sonic Spear", "=ds=#w7#", "11.17%" },
        { 27910, "INV_Shield_36", "=q3=Silvermoon Crest Shield", "=ds=#w8#", "12.46%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27778, "INV_Shoulder_18", "=q3=Spaulders of Oblivion", "=ds=#s3#, #a1# (D3)", "12.28%" },
        { 28232, "INV_Chest_Cloth_29", "=q3=Robe of Oblivion", "=ds=#s5#, #a1# (D3)", "10.47%" },
        { 28230, "INV_Chest_Cloth_39", "=q3=Hallowed Garments", "=ds=#s5#, #a1# (D3)", "11.46%" },
        { 27908, "INV_Pants_Leather_03", "=q3=Leggings of Assassination", "=ds=#s11#, #a2# (D3)", "8.76%" },
        { 27909, "INV_Pants_Mail_06", "=q3=Tidefury Kilt", "=ds=#s11#, #a3# (D3)", "13.87%" },
        { 27803, "INV_Shoulder_26", "=q3=Shoulderguards of the Bold", "=ds=#s3#, #a4# (D3)", "9.49%" },
	};

    AuchShadowMurmurHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29241, "INV_Belt_03", "=q4=Belt of Depravity", "=ds=#s10#, #a1#", "15.47%" },
        { 30532, "INV_Pants_Cloth_16", "=q4=Kirin Tor Master's Trousers", "=ds=#s11#, #a1#", "11.90%" },
        { 29357, "INV_Gauntlets_22", "=q4=Master Thief's Gloves", "=ds=#s9#, #a2#" },
        { 29261, "INV_Belt_30", "=q4=Girdle of Ferocity", "=ds=#s10#, #a3#", "3.57%" },
        { 29353, "INV_Mace_54", "=q4=Shockwave Truncheon", "=ds=#h3#, #w6#", "10.71%" },
        { 0,"","","" },
        { 27902, "INV_Boots_Cloth_09", "=q3=Silent Slippers of Meditation", "=ds=#s12#, #a1#", "4.76%" },
        { 27912, "INV_Chest_Leather_05", "=q3=Harness of the Deep Currents", "=ds=#s5#, #a3#", "13.59%" },
        { 27913, "INV_Weapon_Shortblade_51", "=q3=Whispering Blade of Slaying", "=ds=#h1#, #w4#", "7.14%" },
        { 27905, "INV_Sword_2H_Blood_C_03", "=q3=Greatsword of Horrid Dreams", "=ds=#h3#, #w10#", "4.76%" },
        { 27903, "INV_Spear_08", "=q3=Sonic Spear", "=ds=#w7#", "7.14%" },
        { 27910, "INV_Shield_36", "=q3=Silvermoon Crest Shield", "=ds=#w8#", "5.95%" },
        { 0,"","","" },
        { 31722, "INV_Misc_Orb_05", "=q1=Murmur's Essence", "=ds=#m3#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=Regal Tanzanite", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Etched Fire Opal", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=Rune Covered Chrysoprase", "=ds=#e7#", "15.47%" },
        { 24309, "INV_Scroll_05", "=q4=Pattern: Spellstrike Pants", "=ds=#p8# (375)", "0.37%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27778, "INV_Shoulder_18", "=q3=Spaulders of Oblivion", "=ds=#s3#, #a1# (D3)", "20.24%" },
        { 28232, "INV_Chest_Cloth_29", "=q3=Robe of Oblivion", "=ds=#s5#, #a1# (D3)", "4.76%" },
        { 28230, "INV_Chest_Cloth_39", "=q3=Hallowed Garments", "=ds=#s5#, #a1# (D3)", "7.14%" },
        { 27908, "INV_Pants_Leather_03", "=q3=Leggings of Assassination", "=ds=#s11#, #a2# (D3)", "5.95%" },
        { 27909, "INV_Pants_Mail_06", "=q3=Tidefury Kilt", "=ds=#s11#, #a3# (D3)", "26.19%" },
        { 27803, "INV_Shoulder_26", "=q3=Shoulderguards of the Bold", "=ds=#s3#, #a4# (D3)", "13.10%" },
	};

    AuchShadowFirstFragmentGuardian = {
        { 24514, "INV_Misc_Key_04", "=q1=First Key Fragment", "=ds=#m3#", "100%" },
	};

    AuchShadowTrash = {
        { 23607, "INV_Scroll_05", "=q3=Plans: Felsteel Helm", "=ds=#p2# (365), =q1=#n56#", "0.61%" },
	};

	---------------------------------------------
	--- Hellfire Citadel: The Shattered Halls ---
	---------------------------------------------

    HCHallsNethekurse = {
        { 24312, "INV_Scroll_05", "=q4=Pattern: Spellstrike Hood", "=ds=#p8# (375)", "0.47%" },
        { 0,"","","" },
        { 27519, "INV_Misc_Cape_06", "=q3=Cloak of Malice", "=ds=#s4#", "17.44%" },
        { 27517, "INV_Bracer_13", "=q3=Bands of Nethekurse", "=ds=#s8#, #a1#", "17.52%" },
        { 27521, "INV_Belt_09", "=q3=Telaari Hunting Girdle", "=ds=#s10#, #a3#", "16.50%" },
        { 27520, "INV_Helmet_03", "=q3=Greathelm of the Unbreakable", "=ds=#s1#, #a4#", "16.47%" },
        { 27518, "Spell_Arcane_Arcane03", "=q3=Ivory Idol of the Moongoddess", "=ds=#s16#, #w14#", "17.42%" },
        { 0,"","","" },
        { 23735, "INV_Jewelry_Amulet_04", "=q1=Grand Warlock's Amulet", "=ds=#m3#", "13.91%" },
	};

    HCHallsNethekurseHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 24312, "INV_Scroll_05", "=q4=Pattern: Spellstrike Hood", "=ds=#p8# (375)", "0.47%" },
        { 30548, "INV_Jewelcrafting_Talasite_03", "=q4=Polished Chrysoprase", "=ds=#e7#", "0.16%" },
        { 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Luminous Fire Opal", "=ds=#e7#", "0.19%" },
        { 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=Sovereign Tanzanite", "=ds=#e7#", "3.39%" },
        { 0,"","","" },
        { 27519, "INV_Misc_Cape_06", "=q3=Cloak of Malice", "=ds=#s4#", "19.75%" },
        { 27517, "INV_Bracer_13", "=q3=Bands of Nethekurse", "=ds=#s8#, #a1#", "12.35%" },
        { 27521, "INV_Belt_09", "=q3=Telaari Hunting Girdle", "=ds=#s10#, #a3#", "17.28%" },
        { 27520, "INV_Helmet_03", "=q3=Greathelm of the Unbreakable", "=ds=#s1#, #a4#", "11.11%" },
        { 27518, "Spell_Arcane_Arcane03", "=q3=Ivory Idol of the Moongoddess", "=ds=#s16#, #w14#", "24.69%" },
        { 0,"","","" },
        { 25462, "INV_Misc_Book_06", "=q1=Tome of Dusk", "=ds=#m3#", "100%" },
	};
        
    HCHallsOmrogg = {
        { 27525, "INV_Boots_Cloth_12", "=q3=Jeweled Boots of Sanctification", "=ds=#s12#, #a1#", "18.26%" },
        { 27868, "INV_Weapon_Shortblade_52", "=q3=Runesong Dagger", "=ds=#h3#, #w4#", "15.32%" },
        { 27524, "INV_Mace_36", "=q3=Firemaul of Destruction", "=ds=#h2#, #w6#", "17.95%" },
        { 27526, "INV_Weapon_Bow_17", "=q3=Skyfire Hawk-Bow", "=ds=#w2#", "17.31%" },
        { 0,"","","" },
        { 30829, "INV_Misc_Gem_Diamond_05", "=q1=Tear of the Earthmother", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27802, "INV_Shoulder_31", "=q3=Tidefury Shoulderguards", "=ds=#s3#, #a3# (D3)", "17.02%" },
	};

    HCHallsOmroggHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30548, "INV_Jewelcrafting_Talasite_03", "=q4=Polished Chrysoprase", "=ds=#e7#", "0.16%" },
        { 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Luminous Fire Opal", "=ds=#e7#", "0.19%" },
        { 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=Sovereign Tanzanite", "=ds=#e7#", "3.39%" },
        { 0,"","","" },
        { 27525, "INV_Boots_Cloth_12", "=q3=Jeweled Boots of Sanctification", "=ds=#s12#, #a1#", "14.29%" },
        { 27868, "INV_Weapon_Shortblade_52", "=q3=Runesong Dagger", "=ds=#h3#, #w4#", "24.49%" },
        { 27524, "INV_Mace_36", "=q3=Firemaul of Destruction", "=ds=#h2#, #w6#", "18.37%" },
        { 27526, "INV_Weapon_Bow_17", "=q3=Skyfire Hawk-Bow", "=ds=#w2#", "22.45%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27802, "INV_Shoulder_31", "=q3=Tidefury Shoulderguards", "=ds=#s3#, #a3# (D3)", "8.16%" },
	};
        
    HCHallsKargath = {
        { 27527, "INV_Pants_Plate_01", "=q3=Greaves of the Shatterer", "=ds=#s11#, #a4#", "12.89%" },
        { 27529, "INV_QirajIdol_Rebirth", "=q3=Figurine of the Colossus", "=ds=#s14#", "10.41%" },
        { 27534, "INV_Misc_Gem_LionsEye_01", "=q3=Hortus' Seal of Brilliance", "=ds=#s15#", "12.98%" },
        { 27533, "INV_Weapon_Hand_05", "=q3=Demonblood Eviscerator", "=ds=#h3#, #w13#", "12.70%" },
        { 27538, "INV_Staff_30", "=q3=Lightsworn Hammer", "=ds=#h3#, #w6#", "10.6%" },
        { 27540, "INV_Wand_18", "=q3=Nexus Torch", "=ds=#w12#", "13.02%" },
        { 0,"","","" },
        { 23723, "INV_Weapon_Hand_03", "=q1=Warchief Kargath's Fist", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27536, "INV_Gauntlets_27", "=q3=Hallowed Handwraps", "=ds=#s9#, #a1# (D3)", "12.63%" },
        { 27537, "INV_Gauntlets_16", "=q3=Gloves of Oblivion", "=ds=#s9#, #a1# (D3)", "12.54%" },
        { 27531, "INV_Gauntlets_25", "=q3=Wastewalker Gloves", "=ds=#s9#, #a2# (D3)", "11.03%" },
        { 27474, "INV_Gauntlets_10", "=q3=Beast Lord Handguards", "=ds=#s9#, #a3# (D3)", "10.73%" },
        { 27528, "INV_Gauntlets_10", "=q3=Gauntlets of Desolation", "=ds=#s9#, #a3# (D3)", "13.86%" },
        { 27535, "INV_Gauntlets_29", "=q3=Gauntlets of the Righteous", "=ds=#s9#, #a4# (D3)", "11.24%" },
	};

    HCHallsKargathHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29255, "INV_Bracer_13", "=q4=Bands of Rarefied Magic", "=ds=#s8#, #a1#", "0.58%" },
        { 29263, "INV_Bracer_02", "=q4=Forestheart Bracers", "=ds=#s8#, #a2#", "0.28%" },
        { 29348, "INV_Weapon_Hand_10", "=q4=The Bladefist", "=ds=#h3#, #w13#", "3.39%" },
        { 0,"","","" },
        { 27527, "INV_Pants_Plate_01", "=q3=Greaves of the Shatterer", "=ds=#s11#, #a4#", "13.56%" },
        { 27529, "INV_QirajIdol_Rebirth", "=q3=Figurine of the Colossus", "=ds=#s14#", "11.86%" },
        { 27534, "INV_Misc_Gem_LionsEye_01", "=q3=Hortus' Seal of Brilliance", "=ds=#s15#", "6.78%" },
        { 27533, "INV_Weapon_Hand_05", "=q3=Demonblood Eviscerator", "=ds=#h3#, #w13#", "6.78%" },
        { 27538, "INV_Staff_30", "=q3=Lightsworn Hammer", "=ds=#h3#, #w6#", "16.95%" },
        { 27540, "INV_Wand_18", "=q3=Nexus Torch", "=ds=#w12#", "22.03%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30548, "INV_Jewelcrafting_Talasite_03", "=q4=Polished Chrysoprase", "=ds=#e7#", "0.16%" },
        { 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Luminous Fire Opal", "=ds=#e7#", "0.19%" },
        { 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=Sovereign Tanzanite", "=ds=#e7#", "3.39%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27536, "INV_Gauntlets_27", "=q3=Hallowed Handwraps", "=ds=#s9#, #a1# (D3)", "12.63%" },
        { 27537, "INV_Gauntlets_16", "=q3=Gloves of Oblivion", "=ds=#s9#, #a1# (D3)", "12.54%" },
        { 27531, "INV_Gauntlets_25", "=q3=Wastewalker Gloves", "=ds=#s9#, #a2# (D3)", "11.03%" },
        { 27474, "INV_Gauntlets_10", "=q3=Beast Lord Handguards", "=ds=#s9#, #a3# (D3)", "10.73%" },
        { 27528, "INV_Gauntlets_10", "=q3=Gauntlets of Desolation", "=ds=#s9#, #a3# (D3)", "13.86%" },
        { 27535, "INV_Gauntlets_29", "=q3=Gauntlets of the Righteous", "=ds=#s9#, #a4# (D3)", "11.24%" },
	};

    HCHallsPorung = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30548, "INV_Jewelcrafting_Talasite_03", "=q4=Polished Chrysoprase", "=ds=#e7#", "0.16%" },
        { 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Luminous Fire Opal", "=ds=#e7#", "0.19%" },
        { 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=Sovereign Tanzanite", "=ds=#e7#", "3.39%" },
        { 0,"","","" },
        { 30709, "INV_Pants_Cloth_14", "=q3=Pantaloons of Flaming Wrath", "=ds=#s11#, #a1#", "14.58%" },
        { 30707, "INV_Boots_05", "=q3=Nimble-foot Treads", "=ds=#s12#, #a2#", "10.42%" },
        { 30708, "INV_Belt_03", "=q3=Belt of Flowing Thought", "=ds=#s10#, #a3#", "12.50%" },
        { 30705, "INV_Shoulder_26", "=q3=Spaulders of Slaughter", "=ds=#s3#, #a4#", "21.88%" },
        { 30710, "INV_Jewelry_Necklace_04", "=q3=Blood Guard's Necklace of Ferocity", "=ds=#s2#", "10.42%" },
	};

    HCHallsTrash = {
        { 22554, "INV_Misc_Note_01", "=q2=Formula: Enchant 2H Weapon - Savagery", "=ds=#p4# (350) =q1=#n88#", "1.65%" },
	};

	------------------------------------------
	--- Coilfang Reservoir: The Steamvault ---
	------------------------------------------

    CFRSteamThespia = {
        { 27789, "INV_Misc_Cape_16", "=q3=Cloak of Whispering Shells", "=ds=#s4#", "14.32%" },
        { 27787, "INV_Chest_Plate11", "=q3=Chestguard of No Remorse", "=ds=#s5#, #a2#", "17.65%" },
        { 27783, "INV_Belt_08", "=q3=Moonrage Girdle", "=ds=#s10#, #a2#", "18.71%" },
        { 27784, "INV_Jewelry_Ring_62", "=q3=Scintillating Coral Band", "=ds=#s13#", "16.72%" },
        { 0,"","","" },
        { 29673, "INV_Scroll_06", "=q2=Pattern: Frost Armor Kit", "=ds=#p7# (340)", "0.60%" },
        { 0,"","","" },
        { 30828, "INV_Misc_Powder_Black", "=q1=Vial of Underworld Loam", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27508, "INV_Gauntlets_17", "=q3=Incanter's Gloves", "=ds=#s9#, #a1# (D3)", "17.09%" },
	};

    CFRSteamThespiaHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30550, "INV_Jewelcrafting_Talasite_03", "=q4=Sundered Chrysoprase", "=ds=#e7#", "8.59%" },
        { 30551, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Infused Fire Opal", "=ds=#e7#", "6.64%" },
        { 30549, "INV_Jewelcrafting_Nightseye_03", "=q4=Shifting Tanzanite", "=ds=#e7#", "1.56%" },
        { 0,"","","" },
        { 27789, "INV_Misc_Cape_16", "=q3=Cloak of Whispering Shells", "=ds=#s4#", "18.71%" },
        { 27787, "INV_Chest_Plate11", "=q3=Chestguard of No Remorse", "=ds=#s5#, #a2#", "19.35%" },
        { 27783, "INV_Belt_08", "=q3=Moonrage Girdle", "=ds=#s10#, #a2#", "12.26%" },
        { 27784, "INV_Jewelry_Ring_62", "=q3=Scintillating Coral Band", "=ds=#s13#", "17.42%" },
        { 0,"","","" },
        { 29673, "INV_Scroll_06", "=q2=Pattern: Frost Armor Kit", "=ds=#p7# (340)", "0.60%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27508, "INV_Gauntlets_17", "=q3=Incanter's Gloves", "=ds=#s9#, #a1# (D3)", "14.19%" },
	};

    CFRSteamSecondFragmentGuardian = {
        { 24487, "INV_Misc_Key_03", "=q1=Second Key Fragment", "=ds=#m3#", "100%" },
	};

    CFRSteamSteamrigger = {
        { 27793, "INV_Gauntlets_03", "=q3=Earth Mantle Handwraps", "=ds=#s9#, #a3#", "16.92%" },
        { 27790, "INV_Helmet_74", "=q3=Mask of Pennance", "=ds=#s1#, #a4#", "16.65%" },
        { 27792, "Ability_Rogue_NervesOfSteel", "=q3=Steam-Hinge Chain of Valor", "=ds=#s2#", "14.49%" },
        { 27791, "INV_Staff_48", "=q3=Serpentcrest Life-Staff", "=ds=#w9#", "17.09%" },
        { 27794, "INV_Weapon_Rifle_19", "=q3=Recoilless Rocket Ripper X-54", "=ds=#w5#", "15.88%" },
        { 0,"","","" },
        { 23887, "INV_Scroll_05", "=q3=Schematic: Rocket Boots Xtreme", "=ds=#p5# (355)", "0.52%" },
	};

    CFRSteamSteamriggerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30550, "INV_Jewelcrafting_Talasite_03", "=q4=Sundered Chrysoprase", "=ds=#e7#", "8.59%" },
        { 30551, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Infused Fire Opal", "=ds=#e7#", "6.64%" },
        { 30549, "INV_Jewelcrafting_Nightseye_03", "=q4=Shifting Tanzanite", "=ds=#e7#", "1.56%" },
        { 0,"","","" },
        { 27793, "INV_Gauntlets_03", "=q3=Earth Mantle Handwraps", "=ds=#s9#, #a3#", "17.83%" },
        { 27790, "INV_Helmet_74", "=q3=Mask of Pennance", "=ds=#s1#, #a4#", "17.05%" },
        { 27792, "Ability_Rogue_NervesOfSteel", "=q3=Steam-Hinge Chain of Valor", "=ds=#s2#", "14.73%" },
        { 27791, "INV_Staff_48", "=q3=Serpentcrest Life-Staff", "=ds=#w9#", "7.75%" },
        { 27794, "INV_Weapon_Rifle_19", "=q3=Recoilless Rocket Ripper X-54", "=ds=#w5#", "17.83%" },
        { 0,"","","" },
        { 23887, "INV_Scroll_05", "=q3=Schematic: Rocket Boots Xtreme", "=ds=#p5# (355)", "0.52%" },
	};

    CFRSteamWarlord = {
        { 24313, "INV_Scroll_05", "=q4=Pattern: Battlecast Hood", "=ds=#p8# (375)", "0.20%" },
        { 0,"","","" },
        { 27804, "INV_Misc_Cape_13", "=q3=Devilshark Cape", "=ds=#s4#", "12.18%" },
        { 27799, "INV_Chest_Cloth_18", "=q3=Vermillion Robes of the Dominant", "=ds=#s5#, #a1#", "12.47%" },
        { 27795, "INV_Belt_13", "=q3=Sash of Serpentra", "=ds=#s10#, #a1#", "11.03%" },
        { 27806, "INV_Gauntlets_10", "=q3=Fathomheart Gauntlets", "=ds=#s9#, #a3#", "14.84%" },
        { 27805, "INV_Jewelry_Ring_66", "=q3=Ring of the Silver Hand", "=ds=#s13#", "13.95%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27738, "INV_Shoulder_02", "=q3=Incanter's Pauldrons", "=ds=#s3#, #a1# (D3)", "12.25%" },
        { 27737, "INV_Shoulder_24", "=q3=Moonglade Shoulders", "=ds=#s3#, #a2# (D3)", "12.89%" },
        { 27801, "INV_Shoulder_23", "=q3=Beast Lord Mantle", "=ds=#s3#, #a3# (D3)", "10.63%" },
        { 27510, "INV_Gauntlets_10", "=q3=Tidefury Gauntlets", "=ds=#s9#, #a3# (D3)", "12.45%" },
        { 27874, "INV_Pants_03", "=q3=Beast Lord Leggings", "=ds=#s11#, #a3# (D3)", "9.56%" },
        { 28203, "INV_Chest_Chain_15", "=q3=Breastplate of the Righteous", "=ds=#s5#, #a4# (D3)", "10.98%" },
        { 27475, "INV_Gauntlets_28", "=q3=Gauntlets of the Bold", "=ds=#s9#, #a4# (D3)", "10.05%" },
	};

    CFRSteamWarlordHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30543, "INV_Pants_Cloth_20", "=q4=Pontifex Kilt", "=ds=#s11#, #a1#", "7.81%" },
        { 29243, "INV_Bracer_02", "=q4=Wave-Fury Vambraces", "=ds=#s8#, #a3#", "17.97%" },
        { 29463, "INV_Bracer_02", "=q4=Amber Bands of the Aggressor", "=ds=#s8#, #a4#", "2.34%" },
        { 29351, "INV_Weapon_Crossbow_16", "=q4=Wrathtide Longbow", "=ds=#w2#", "3.52%" },
        { 0,"","","" },
        { 27804, "INV_Misc_Cape_13", "=q3=Devilshark Cape", "=ds=#s4#", "15.23%" },
        { 27799, "INV_Chest_Cloth_18", "=q3=Vermillion Robes of the Dominant", "=ds=#s5#, #a1#", "8.59%" },
        { 27795, "INV_Belt_13", "=q3=Sash of Serpentra", "=ds=#s10#, #a1#", "15.62%" },
        { 27806, "INV_Gauntlets_10", "=q3=Fathomheart Gauntlets", "=ds=#s9#, #a3#", "13.28%" },
        { 27805, "INV_Jewelry_Ring_66", "=q3=Ring of the Silver Hand", "=ds=#s13#", "8.98%" },
        { 0,"","","" },
        { 31721, "INV_Misc_Shovel_02", "=q1=Kalithresh's Trident", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 24313, "INV_Scroll_05", "=q4=Pattern: Battlecast Hood", "=ds=#p8# (375)", "0.20%" },
        { 30550, "INV_Jewelcrafting_Talasite_03", "=q4=Sundered Chrysoprase", "=ds=#e7#", "8.59%" },
        { 30551, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Infused Fire Opal", "=ds=#e7#", "6.64%" },
        { 30549, "INV_Jewelcrafting_Nightseye_03", "=q4=Shifting Tanzanite", "=ds=#e7#", "1.56%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27738, "INV_Shoulder_02", "=q3=Incanter's Pauldrons", "=ds=#s3#, #a1# (D3)", "10.94%" },
        { 27737, "INV_Shoulder_24", "=q3=Moonglade Shoulders", "=ds=#s3#, #a2# (D3)", "7.03%" },
        { 27801, "INV_Shoulder_23", "=q3=Beast Lord Mantle", "=ds=#s3#, #a3# (D3)", "8.59%" },
        { 27510, "INV_Gauntlets_10", "=q3=Tidefury Gauntlets", "=ds=#s9#, #a3# (D3)", "11.72%" },
        { 27874, "INV_Pants_03", "=q3=Beast Lord Leggings", "=ds=#s11#, #a3# (D3)", "6.64%" },
        { 28203, "INV_Chest_Chain_15", "=q3=Breastplate of the Righteous", "=ds=#s5#, #a4# (D3)", "13.28%" },
        { 27475, "INV_Gauntlets_28", "=q3=Gauntlets of the Bold", "=ds=#s9#, #a4# (D3)", "7.81%" },
	};

    CFRSteamTrash = {
        { 24159, "INV_Scroll_05", "=q3=Design: Khorium Band of Frost", "=ds=#p12# (355) =q1=#n86#", "0.14%" },
        { 0,"","","" },
        { 22533, "INV_Misc_Note_01", "=q2=Formula: Enchant Bracer - Fortitude", "=ds=#p4# (350) =q1=#n87#", "0.40%" },
        { 0,"","","" },
        { 24367, "INV_Misc_Note_06", "=q1=Orders from Lady Vashj", "=ds=#m2#" },
        { 24368, "INV_Spear_06", "=q1=Coilfang Armaments", "=ds=#m3#", "12.68%" },
	};

	-----------------------------------------
	--- Caverns of Time: The Black Morass ---
	-----------------------------------------

    CoTMorassDeja = {
        { 27988, "INV_Misc_Cape_15", "=q3=Burnoose of Shifting Ages", "=ds=#s4#", "13.87%" },
        { 27994, "INV_Shoulder_36", "=q3=Mantle of Three Terrors", "=ds=#s3#, #a1#", "12.30%" },
        { 27995, "INV_Shoulder_08", "=q3=Sun-Gilded Shouldercaps", "=ds=#s3#, #a2#", "13.13%" },
        { 27993, "INV_Helmet_17", "=q3=Mask of Inner Fire", "=ds=#s1#, #a3#", "13.84%" },
        { 27996, "INV_Jewelry_Ring_59", "=q3=Ring of Spiritual Precision", "=ds=#s13#", "14.45%" },
        { 27987, "INV_Weapon_Bow_19", "=q3=Melmorta's Twilight Longbow", "=ds=#w2#", "11.51%" },
        { 0,"","","" },
        { 29675, "INV_Scroll_06", "=q2=Pattern: Arcane Armor Kit", "=ds=#p7# (340)", "0.35%" },
	};

    CoTMorassDejaHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30558, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glimmering Fire Opal", "=ds=#e7#" },
        { 30556, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glinting Fire Opal", "=ds=#e7#" },
        { 30555, "INV_Jewelcrafting_Nightseye_03", "=q4=Glowing Tanzanite", "=ds=#e7#" },
        { 0,"","","" },
        { 27988, "INV_Misc_Cape_15", "=q3=Burnoose of Shifting Ages", "=ds=#s4#", "14.29%" },
        { 27994, "INV_Shoulder_36", "=q3=Mantle of Three Terrors", "=ds=#s3#, #a1#", "12.86%" },
        { 27995, "INV_Shoulder_08", "=q3=Sun-Gilded Shouldercaps", "=ds=#s3#, #a2#", "21.43%" },
        { 27993, "INV_Helmet_17", "=q3=Mask of Inner Fire", "=ds=#s1#, #a3#", "11.43%" },
        { 27996, "INV_Jewelry_Ring_59", "=q3=Ring of Spiritual Precision", "=ds=#s13#", "7.14%" },
        { 27987, "INV_Weapon_Bow_19", "=q3=Melmorta's Twilight Longbow", "=ds=#w2#", "11.43%" },
        { 0,"","","" },
        { 29675, "INV_Scroll_06", "=q2=Pattern: Arcane Armor Kit", "=ds=#p7# (340)", "0.35%" },
	};

    CoTMorassTemporus = {
        { 28185, "INV_Pants_Leather_05", "=q3=Khadgar's Kilt of Abjuration", "=ds=#s11#, #a1#", "14.26%" },
        { 28186, "INV_Chest_Leather_04", "=q3=Laughing Skull Battle-Harness", "=ds=#s5#, #a3#", "13.14%" },
        { 28034, "INV_Gizmo_KhoriumPowerCore", "=q3=Hourglass of the Unraveller", "=ds=#s14#", "13.69%" },
        { 28187, "INV_Offhand_OutlandRaid_03blue", "=q3=Star-Heart Lamp", "=ds=#s15#", "11.83%" },
        { 28184, "INV_Sword_64", "=q3=Millennium Blade", "=ds=#h1#, #w10#", "11.74%" },
        { 28033, "INV_Staff_46", "=q3=Epoch-Mender", "=ds=#w9#", "13.80%" },
	};

    CoTMorassTemporusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30558, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glimmering Fire Opal", "=ds=#e7#" },
        { 30556, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glinting Fire Opal", "=ds=#e7#" },
        { 30555, "INV_Jewelcrafting_Nightseye_03", "=q4=Glowing Tanzanite", "=ds=#e7#" },
        { 0,"","","" },
        { 28185, "INV_Pants_Leather_05", "=q3=Khadgar's Kilt of Abjuration", "=ds=#s11#, #a1#", "12.77%" },
        { 28186, "INV_Chest_Leather_04", "=q3=Laughing Skull Battle-Harness", "=ds=#s5#, #a3#", "14.89%" },
        { 28034, "INV_Gizmo_KhoriumPowerCore", "=q3=Hourglass of the Unraveller", "=ds=#s14#", "8.51%" },
        { 28187, "INV_Offhand_OutlandRaid_03blue", "=q3=Star-Heart Lamp", "=ds=#s15#", "8.51%" },
        { 28184, "INV_Sword_64", "=q3=Millennium Blade", "=ds=#h1#, #w10#", "25.53%" },
        { 28033, "INV_Staff_46", "=q3=Epoch-Mender", "=ds=#w9#", "12.77%" },
	};

    CoTMorassAeonus = {
        { 28206, "INV_Helmet_29", "=q3=Cowl of the Guiltless", "=ds=#s1#, #a2#", "12.25%" },
        { 28194, "INV_Bracer_12", "=q3=Primal Surge Bracers", "=ds=#s8#, #a3#", "13.51%" },
        { 28207, "INV_Shoulder_01", "=q3=Pauldrons of the Crimson Flight", "=ds=#s3#, #a4#", "11.11%" },
        { 28190, "INV_Misc_AhnQirajTrinket_06", "=q3=Scarab of the Infinite Cycle", "=ds=#s14#", "11.32%" },
        { 28189, "INV_Sword_76", "=q3=Latro's Shifting Sword", "=ds=#h1#, #w10#", "9.70%" },
        { 28188, "INV_Staff_40", "=q3=Bloodfire Greatstaff", "=ds=#w9#", "10.48%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28193, "INV_Jewelry_Ring_56", "=q3=Mana-Etched Crown", "=ds=#s1#, #a1# (D3)", "11.99%" },
        { 27509, "INV_Gauntlets_01", "=q3=Handgrips of Assassination", "=ds=#s9#, #a2# (D3)", "12.84%" },
        { 27873, "INV_Pants_14", "=q3=Moonglade Pants", "=ds=#s11#, #a2# (D3)", "11.28%" },
        { 28192, "INV_Helmet_18", "=q3=Helm of Desolation", "=ds=#s1#, #a3# (D3)", "12.77%" },
        { 27977, "INV_Pants_Plate_06", "=q3=Legplates of the Bold", "=ds=#s11#, #a4# (D3)", "9.92%" },
        { 27839, "INV_Pants_04", "=q3=Legplates of the Righteous", "=ds=#s11#, #a4# (D3)", "12.10%" },
	};

    CoTMorassAeonusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30531, "INV_Pants_Mail_20", "=q4=Breeches of the Occultist", "=ds=#s11#, #a1#", "1.49%" },
        { 29247, "INV_Belt_26", "=q4=Girdle of the Deathdealer", "=ds=#s10#, #a2#" },
        { 29253, "INV_Belt_11", "=q4=Girdle of Valorous Deeds", "=ds=#s10#, #a4#" },
        { 29356, "INV_Sword_81", "=q4=Quantum Blade", "=ds=#h2#, #w10#" },
        { 0,"","","" },
        { 28206, "INV_Helmet_29", "=q3=Cowl of the Guiltless", "=ds=#s1#, #a2#", "17.91%" },
        { 28194, "INV_Bracer_12", "=q3=Primal Surge Bracers", "=ds=#s8#, #a3#", "7.46%" },
        { 28207, "INV_Shoulder_01", "=q3=Pauldrons of the Crimson Flight", "=ds=#s3#, #a4#", "11.94%" },
        { 28190, "INV_Misc_AhnQirajTrinket_06", "=q3=Scarab of the Infinite Cycle", "=ds=#s14#", "14.93%" },
        { 28189, "INV_Sword_76", "=q3=Latro's Shifting Sword", "=ds=#h1#, #w10#", "5.97%" },
        { 28188, "INV_Staff_40", "=q3=Bloodfire Greatstaff", "=ds=#w9#", "20.90%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30558, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glimmering Fire Opal", "=ds=#e7#" },
        { 30556, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Glinting Fire Opal", "=ds=#e7#" },
        { 30555, "INV_Jewelcrafting_Nightseye_03", "=q4=Glowing Tanzanite", "=ds=#e7#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28193, "INV_Jewelry_Ring_56", "=q3=Mana-Etched Crown", "=ds=#s1#, #a1# (D3)", "7.46%" },
        { 27509, "INV_Gauntlets_01", "=q3=Handgrips of Assassination", "=ds=#s9#, #a2# (D3)", "5.97%" },
        { 27873, "INV_Pants_14", "=q3=Moonglade Pants", "=ds=#s11#, #a2# (D3)", "16.42%" },
        { 28192, "INV_Helmet_18", "=q3=Helm of Desolation", "=ds=#s1#, #a3# (D3)", "19.40%" },
        { 27977, "INV_Pants_Plate_06", "=q3=Legplates of the Bold", "=ds=#s11#, #a4# (D3)", "8.96%" },
        { 27839, "INV_Pants_04", "=q3=Legplates of the Righteous", "=ds=#s11#, #a4# (D3)", "7.46%" },
	};

    CoTMorassTrash = {
        { 25730, "INV_Scroll_05", "=q3=Pattern: Stylin' Jungle Hat", "=ds=#p7# (350) =q1=#n95#", "0.29%" },
	};

	----------------------------------
	--- Tempest Keep: The Mechanar ---
	----------------------------------

    TKMechGyro = {
        { 30436, "INV_Misc_Gem_AzureDraenite_03", "=q1=Jagged Blue Crystal", "=ds=#e9#", "100%" },
	};

    TKMechGyroHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 0,"","","" },
        { 30436, "INV_Misc_Gem_AzureDraenite_03", "=q1=Jagged Blue Crystal", "=ds=#e9#", "100%" },
	};

    TKMechIron = {
        { 30437, "INV_Misc_Gem_BloodGem_03", "=q1=Jagged Red Crystal", "=ds=#e9#", "100%" },
	};

    TKMechIronHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 0,"","","" },
        { 30437, "INV_Misc_Gem_BloodGem_03", "=q1=Jagged Red Crystal", "=ds=#e9#", "100%" },
	};

    TKMechCacheoftheLegion = {
        { 28249, "INV_Misc_Cape_20", "=q3=Capacitus' Cloak of Calibration", "=ds=#s4#", "21.16%" },
        { 28250, "INV_Shoulder_35", "=q3=Vestia's Pauldrons of Inner Grace", "=ds=#s3#, #a1#", "17.89%" },
        { 28252, "INV_Chest_Cloth_25", "=q3=Bloodfyre Robes of Annihilation", "=ds=#s5#, #a1#", "22.53%" },
        { 28251, "INV_Boots_05", "=q3=Boots of the Glade-Keeper", "=ds=#s12#, #a2#", "18.74%" },
        { 28248, "Spell_Arcane_Blast", "=q3=Totem of the Void", "=ds=#s16#, #w15#", "19.58%" },
	};

    TKMechCapacitus = {
        { 28256, "INV_Misc_Cape_11", "=q3=Thoriumweave Cloak", "=ds=#s4#", "14.81%" },
        { 28255, "INV_Shoulder_19", "=q3=Lunar-Claw Pauldrons", "=ds=#s3#, #a2#", "16.98%" },
        { 28254, "INV_Jewelry_Necklace_30Naxxramas", "=q3=Warp Engineer's Prismatic Chain", "=ds=#s2#", "16.81%" },
        { 28257, "INV_Mace_13", "=q3=Hammer of the Penitent", "=ds=#h3#, #w6#", "14.36%" },
        { 28253, "INV_Weapon_Halberd15", "=q3=Plasma Rat's Hyper-Scythe", "=ds=#w7#", "17.69%" },
	};

    TKMechCapacitusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30565, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Assassin's Fire Opal", "=ds=#e7#", "18.72%" },
        { 30566, "INV_Jewelcrafting_Nightseye_03", "=q4=Defender's Tanzanite", "=ds=#e7#", "8.87%" },
        { 30564, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Shining Fire Opal", "=ds=#e7#", "3.45%" },
        { 0,"","","" },
        { 28256, "INV_Misc_Cape_11", "=q3=Thoriumweave Cloak", "=ds=#s4#", "11.95%" },
        { 28255, "INV_Shoulder_19", "=q3=Lunar-Claw Pauldrons", "=ds=#s3#, #a2#", "17.13%" },
        { 28254, "INV_Jewelry_Necklace_30Naxxramas", "=q3=Warp Engineer's Prismatic Chain", "=ds=#s2#", "18.33%" },
        { 28257, "INV_Mace_13", "=q3=Hammer of the Penitent", "=ds=#h3#, #w6#", "11.95%" },
        { 28253, "INV_Weapon_Halberd15", "=q3=Plasma Rat's Hyper-Scythe", "=ds=#w7#", "19.12%" },
	};

    TKMechSepethrea = {
        { 28262, "INV_Chest_Plate07", "=q3=Jade-Skull Breastplate", "=ds=#s5#, #a4#", "15.37%" },
        { 28259, "INV_Jewelry_Ring_62", "=q3=Cosmic Lifeband", "=ds=#s13#", "18.06%" },
        { 28260, "INV_Misc_Book_05", "=q3=Manual of the Nethermancer", "=ds=#s15#", "15.61%" },
        { 28263, "INV_Axe_63", "=q3=Stellaris", "=ds=#h1#, #w1#", "15.58%" },
        { 28258, "INV_Misc_Coin_10", "=q3=Nethershrike", "=ds=#w11#", "15.88%" },
	};

    TKMechSepethreaHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30565, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Assassin's Fire Opal", "=ds=#e7#", "18.72%" },
        { 30566, "INV_Jewelcrafting_Nightseye_03", "=q4=Defender's Tanzanite", "=ds=#e7#", "8.87%" },
        { 30564, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Shining Fire Opal", "=ds=#e7#", "3.45%" },
        { 0,"","","" },
        { 28262, "INV_Chest_Plate07", "=q3=Jade-Skull Breastplate", "=ds=#s5#, #a4#", "14.63%" },
        { 28259, "INV_Jewelry_Ring_62", "=q3=Cosmic Lifeband", "=ds=#s13#", "26.22%" },
        { 28260, "INV_Misc_Book_05", "=q3=Manual of the Nethermancer", "=ds=#s15#", "25.61%" },
        { 28263, "INV_Axe_63", "=q3=Stellaris", "=ds=#h1#, #w1#", "9.15%" },
        { 28258, "INV_Misc_Coin_10", "=q3=Nethershrike", "=ds=#w11#", "14.63%" },
	};

    TKMechCalc = {
        { 28269, "INV_Misc_Cape_05", "=q3=Baba's Cloak of Arcanistry", "=ds=#s4#", "11.78%" },
        { 28266, "INV_Pants_Plate_02", "=q3=Molten Earth Kilt", "=ds=#s11#, #a3#", "12.26%" },
        { 28265, "INV_Jewelry_Ring_50Naxxramas", "=q3=Dath'Remar's Ring of Defense", "=ds=#s13#", "10.61%" },
        { 28288, "INV_Misc_EngGizmos_18", "=q3=Abacus of Violent Odds", "=ds=#s14#", "10.54%" },
        { 27899, "INV_Sword_draenei_04", "=q3=Mana Wrath", "=ds=#h3#, #w10#", "11.38%" },
        { 28267, "INV_Sword_77", "=q3=Edge of the Cosmos", "=ds=#h1#, #w10#", "11.13%" },
        { 28286, "INV_Weapon_Rifle_22", "=q3=Telescopic Sharprifle", "=ds=#w5#", "12.28%" },
        { 0,"","","" },
        { 21907, "INV_Scroll_06", "=q2=Pattern: Arcanoweave Robe", "=ds=#p8# (370)", "1.11%" },
        { 0,"","","" },
        { 31086, "INV_Misc_Gem_BloodGem_01", "=q1=Bottom Shard of the Arcatraz Key", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28278, "INV_Helmet_34", "=q3=Incanter's Cowl", "=ds=#s1#, #a1# (D3)", "13.39%" },
        { 28202, "INV_Chest_Cloth_07", "=q3=Moonglade Robe", "=ds=#s5#, #a2# (D3)", "11.92%" },
        { 28204, "INV_Chest_Chain_17", "=q3=Tunic of Assassination", "=ds=#s5#, #a2# (D3)", "12.44%" },
        { 28275, "INV_Helmet_19", "=q3=Beast Lord Helm", "=ds=#s1#, #a3# (D3)", "12.37%" },
        { 28285, "INV_Helmet_25", "=q3=Helm of the Righteous", "=ds=#s1#, #a4# (D3)", "10.88%" },
	};

    TKMechCalcHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29251, "INV_Boots_Cloth_03", "=q4=Boots of the Pious", "=ds=#s12#, #a1#", "7.88%" },
        { 32076, "Inv_Gauntlets_31", "=q4=Handguards of the Steady", "=ds=#s9#, #a3#" },
        { 30533, "INV_Pants_Plate_21", "=q4=Vanquisher's Legplates", "=ds=#s11#, #a4#", "6.90%" },
        { 29362, "INV_Sword_63", "=q4=The Sun Eater", "=ds=#h1#, #w10#", "1.48%" },
        { 0,"","","" },
        { 28269, "INV_Misc_Cape_05", "=q3=Baba's Cloak of Arcanistry", "=ds=#s4#", "11.82%" },
        { 28266, "INV_Pants_Plate_02", "=q3=Molten Earth Kilt", "=ds=#s11#, #a3#", "14.29%" },
        { 28265, "INV_Jewelry_Ring_50Naxxramas", "=q3=Dath'Remar's Ring of Defense", "=ds=#s13#", "8.87%" },
        { 28288, "INV_Misc_EngGizmos_18", "=q3=Abacus of Violent Odds", "=ds=#s14#", "8.37%" },
        { 27899, "INV_Sword_draenei_04", "=q3=Mana Wrath", "=ds=#h3#, #w10#", "9.36%" },
        { 28267, "INV_Sword_77", "=q3=Edge of the Cosmos", "=ds=#h1#, #w10#", "11.82%" },
        { 28286, "INV_Weapon_Rifle_22", "=q3=Telescopic Sharprifle", "=ds=#w5#", "9.85%" },
        { 0,"","","" },
        { 21907, "INV_Scroll_06", "=q2=Pattern: Arcanoweave Robe", "=ds=#p8# (370)", "1.11%" },
        { 30565, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Assassin's Fire Opal", "=ds=#e7#", "18.72%" },
        { 30566, "INV_Jewelcrafting_Nightseye_03", "=q4=Defender's Tanzanite", "=ds=#e7#", "8.87%" },
        { 30564, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Shining Fire Opal", "=ds=#e7#", "3.45%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28278, "INV_Helmet_34", "=q3=Incanter's Cowl", "=ds=#s1#, #a1# (D3)", "14.29%" },
        { 28202, "INV_Chest_Cloth_07", "=q3=Moonglade Robe", "=ds=#s5#, #a2# (D3)", "11.33%" },
        { 28204, "INV_Chest_Chain_17", "=q3=Tunic of Assassination", "=ds=#s5#, #a2# (D3)", "8.87%" },
        { 28275, "INV_Helmet_19", "=q3=Beast Lord Helm", "=ds=#s1#, #a3# (D3)", "14.78%" },
        { 28285, "INV_Helmet_25", "=q3=Helm of the Righteous", "=ds=#s1#, #a4# (D3)", "10.34%" },
	};
 
    TKMechTrash = {
        { 22920, "INV_Scroll_06", "=q2=Recipe: Major Fire Protection Potion", "=ds=#p1# (360) =q1=#n93#", "0.30%" },
        { 21906, "INV_Scroll_06", "=q2=Pattern: Arcanoweave Boots", "=ds=#p8# (360) =q1=#n93#", "0.57%" },
	};

	----------------------------------
	--- Tempest Keep: The Botanica ---
	----------------------------------
	
    TKBotSarannis = {
        { 28301, "INV_Misc_Cape_Naxxramas_01", "=q3=Syrannis' Mystic Sheen", "=ds=#s4#", "28.54%" },
        { 28304, "INV_Gauntlets_16", "=q3=Prismatic Mittens of Mending", "=ds=#s9#, #a1#", "32.46%" },
        { 28306, "INV_Shoulder_11", "=q3=Towering Mantle of the Hunt", "=ds=#s3#, #a3#", "30.68%" },
        { 28296, "INV_Misc_Book_12", "=q3=Libram of the Lightbringer", "=ds=#s16#, #w16#", "34.10%" },
        { 28311, "INV_Sword_79", "=q3=Revenger", "=ds=#h1#, #w10#", "26.25%" },
        { 0,"","","" },
        { 28769, "INV_Misc_Rune_12", "=q1=The Keystone", "=ds=#m3#", "100%" },
	};

    TKBotSarannisHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=Brutal Tanzanite", "=ds=#e7#", "8.00%" },
        { 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=Imperial Tanzanite", "=ds=#e7#", "8.00%" },
        { 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=Mysterious Fire Opal", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 28301, "INV_Misc_Cape_Naxxramas_01", "=q3=Syrannis' Mystic Sheen", "=ds=#s4#", "19.35%" },
        { 28304, "INV_Gauntlets_16", "=q3=Prismatic Mittens of Mending", "=ds=#s9#, #a1#", "38.71%" },
        { 28306, "INV_Shoulder_11", "=q3=Towering Mantle of the Hunt", "=ds=#s3#, #a3#", "48.39%" },
        { 28296, "INV_Misc_Book_12", "=q3=Libram of the Lightbringer", "=ds=#s16#, #w16#", "38.71%" },
        { 28311, "INV_Sword_79", "=q3=Revenger", "=ds=#h1#, #w10#", "16.13%" },
	};

    TKBotFreywinn = {
        { 28317, "INV_Gauntlets_19", "=q3=Energis Armwraps", "=ds=#s9#, #a1#", "17.60%" },
        { 28318, "INV_Boots_Plate_06", "=q3=Obsidian Clodstompers", "=ds=#s12#, #a4#", "16.48%" },
        { 28321, "INV_jewelry_ring_AhnQiraj_01", "=q3=Enchanted Thorium Torque", "=ds=#s2#", "18.09%" },
        { 28315, "INV_Weapon_Hand_08", "=q3=Stormreaver Warblades", "=ds=#h4#, #w13#", "16.75%" },
        { 28316, "INV_Shield_35", "=q3=Aegis of the Sunbird", "=ds=#w8#", "14.60%" },
        { 0,"","","" },
        { 23617, "INV_Scroll_05", "=q3=Plans: Earthpeace Breastplate", "=ds=#p2# (370)", "1.07%" },
	};

    TKBotFreywinnHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=Brutal Tanzanite", "=ds=#e7#", "8.00%" },
        { 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=Imperial Tanzanite", "=ds=#e7#", "8.00%" },
        { 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=Mysterious Fire Opal", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 28317, "INV_Gauntlets_19", "=q3=Energis Armwraps", "=ds=#s9#, #a1#", "3.70%" },
        { 28318, "INV_Boots_Plate_06", "=q3=Obsidian Clodstompers", "=ds=#s12#, #a4#", "22.22%" },
        { 28321, "INV_jewelry_ring_AhnQiraj_01", "=q3=Enchanted Thorium Torque", "=ds=#s2#", "18.52%" },
        { 28315, "INV_Weapon_Hand_08", "=q3=Stormreaver Warblades", "=ds=#h4#, #w13#", "29.63%" },
        { 28316, "INV_Shield_35", "=q3=Aegis of the Sunbird", "=ds=#w8#", "22.22%" },
        { 0,"","","" },
        { 23617, "INV_Scroll_05", "=q3=Plans: Earthpeace Breastplate", "=ds=#p2# (370)", "1.07%" },
	};

    TKBotThorngrin = {
        { 24310, "INV_Scroll_05", "=q4=Pattern: Battlecast Pants", "=ds=#p8# (375)", "0.44%" },
        { 0,"","","" },
        { 28324, "INV_Gauntlets_26", "=q3=Gauntlets of Cruel Intention", "=ds=#s9#, #a4#", "15.56%" },
        { 28327, "INV_Jewelry_Ring_62", "=q3=Arcane Netherband", "=ds=#s13#", "17.77%" },
        { 28323, "INV_Jewelry_Ring_16", "=q3=Ring of Umbral Doom", "=ds=#s13#", "16.25%" },
        { 28322, "INV_Weapon_Shortblade_52", "=q3=Runed Dagger of Solace", "=ds=#h3#, #w4#", "18.16%" },
        { 28325, "INV_Staff_49", "=q3=Dreamer's Dragonstaff", "=ds=#w9#", "15.46%" },
	};

    TKBotThorngrinHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=Brutal Tanzanite", "=ds=#e7#", "8.00%" },
        { 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=Imperial Tanzanite", "=ds=#e7#", "8.00%" },
        { 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=Mysterious Fire Opal", "=ds=#e7#", "8.00%" },
        { 24310, "INV_Scroll_05", "=q4=Pattern: Battlecast Pants", "=ds=#p8# (375)", "0.44%" },
        { 0,"","","" },
        { 28324, "INV_Gauntlets_26", "=q3=Gauntlets of Cruel Intention", "=ds=#s9#, #a4#", "25.00%" },
        { 28327, "INV_Jewelry_Ring_62", "=q3=Arcane Netherband", "=ds=#s13#", "12.50%" },
        { 28323, "INV_Jewelry_Ring_16", "=q3=Ring of Umbral Doom", "=ds=#s13#", "16.25%" },
        { 28322, "INV_Weapon_Shortblade_52", "=q3=Runed Dagger of Solace", "=ds=#h3#, #w4#", "41.67%" },
        { 28325, "INV_Staff_49", "=q3=Dreamer's Dragonstaff", "=ds=#w9#", "16.67%" },
	};

    TKBotLaj = {
        { 28328, "INV_Misc_Cape_09", "=q3=Mithril-Bark Cloak", "=ds=#s4#", "20.88%" },
        { 28338, "INV_Pants_Cloth_14", "=q3=Devil-Stitched Leggings", "=ds=#s11#, #a1#", "18.71%" },
        { 28340, "INV_Shoulder_18", "=q3=Mantle of Autumn", "=ds=#s3#, #a2#", "17.19%" },
        { 28339, "INV_Boots_05", "=q3=Boots of the Shifting Sands", "=ds=#s12#, #a2#", "19.07%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27739, "INV_Shoulder_10", "=q3=Spaulders of the Righteous", "=ds=#s3#, #a4# (D3)", "18.13%" },
	};

    TKBotLajHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=Brutal Tanzanite", "=ds=#e7#", "8.00%" },
        { 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=Imperial Tanzanite", "=ds=#e7#", "8.00%" },
        { 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=Mysterious Fire Opal", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 28328, "INV_Misc_Cape_09", "=q3=Mithril-Bark Cloak", "=ds=#s4#", "25.00%" },
        { 28338, "INV_Pants_Cloth_14", "=q3=Devil-Stitched Leggings", "=ds=#s11#, #a1#", "20.00%" },
        { 28340, "INV_Shoulder_18", "=q3=Mantle of Autumn", "=ds=#s3#, #a2#", "40.00%" },
        { 28339, "INV_Boots_05", "=q3=Boots of the Shifting Sands", "=ds=#s12#, #a2#", "15.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27739, "INV_Shoulder_10", "=q3=Spaulders of the Righteous", "=ds=#s3#, #a4# (D3)", "18.13%" },
	};

    TKBotSplinter = {
        { 24311, "INV_Scroll_05", "=q4=Pattern: Whitemend Hood", "=ds=#p8# (375)", "0.30%" },
        { 0,"","","" },
        { 28371, "INV_Misc_Cape_02", "=q3=Netherfury Cape", "=ds=#s4#", "13.52%" },
        { 28342, "INV_Chest_Cloth_29", "=q3=Warp Infused Drape", "=ds=#s5#, #a1#", "10.27%" },
        { 28347, "INV_Pants_Mail_21", "=q3=Warpscale Leggings", "=ds=#s11#, #a2#", "11.74%" },
        { 28343, "INV_Jewelry_Necklace_17", "=q3=Jagged Bark Pendant", "=ds=#s2#", "12.34%" },
        { 28370, "INV_Jewelry_Necklace_27", "=q3=Bangle of Endless Blessings", "=ds=#s14#", "12.38%" },
        { 28345, "INV_Weapon_Shortblade_57", "=q3=Warp Splinter's Thorn", "=ds=#h1#, #w4#", "10.37%" },
        { 28367, "INV_Sword_58", "=q3=Greatsword of Forlorn Visions", "=ds=#h2#, #w10#", "11.64%" },
        { 28341, "INV_Staff_47", "=q3=Warpstaff of Arcanum", "=ds=#w9#", "10.47%" },
        { 0,"","","" },
        { 31085, "INV_Misc_Gem_AzureDraenite_01", "=q1=Top Shard of the Arcatraz Key", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28229, "INV_Chest_Cloth_25", "=q3=Incanter's Robe", "=ds=#s5#, #a1# (D3)", "8.42%" },
        { 28348, "INV_Helmet_15", "=q3=Moonglade Cowl", "=ds=#s1#, #a2# (D3)", "11.17%" },
        { 28349, "INV_Helmet_19", "=q3=Tidefury Helm", "=ds=#s1#, #a3# (D3)", "13.85%" },
        { 28228, "INV_Chest_Chain_03", "=q3=Beast Lord Curiass", "=ds=#s5#, #a3# (D3)", "9.59%" },
        { 28350, "INV_Helmet_20", "=q3=Warhelm of the Bold", "=ds=#s1#, #a4# (D3)", "8.96%" },
	};

    TKBotSplinterHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29258, "Inv_Boots_Cloth_06", "=q4=Boots of Ethereal Manipulation", "=ds=#s11#, #a1#" },
        { 29262, "INV_Boots_Chain_05", "=q4=Boots of the Endless Hunt", "=ds=#s12#, #a3#", "4.00%" },
        { 32072, "INV_Gauntlets_28", "=q4=Gauntlets of Dissension", "=ds=#s9#, #a4#" },
        { 29359, "INV_Staff_56", "=q4=Feral Staff of Lashing", "=ds=#w9#" },
        { 24311, "INV_Scroll_05", "=q4=Pattern: Whitemend Hood", "=ds=#p8# (375)", "0.30%" },
        { 0,"","","" },
        { 28371, "INV_Misc_Cape_02", "=q3=Netherfury Cape", "=ds=#s4#", "4.00%" },
        { 28342, "INV_Chest_Cloth_29", "=q3=Warp Infused Drape", "=ds=#s5#, #a1#", "8.00%" },
        { 28347, "INV_Pants_Mail_21", "=q3=Warpscale Leggings", "=ds=#s11#, #a2#", "12.00%" },
        { 28343, "INV_Jewelry_Necklace_17", "=q3=Jagged Bark Pendant", "=ds=#s2#", "4.00%" },
        { 28370, "INV_Jewelry_Necklace_27", "=q3=Bangle of Endless Blessings", "=ds=#s14#", "28.00%" },
        { 28345, "INV_Weapon_Shortblade_57", "=q3=Warp Splinter's Thorn", "=ds=#h1#, #w4#", "28.00%" },
        { 28367, "INV_Sword_58", "=q3=Greatsword of Forlorn Visions", "=ds=#h2#, #w10#", "8.00%" },
        { 28341, "INV_Staff_47", "=q3=Warpstaff of Arcanum", "=ds=#w9#", "4.00%" },
        { 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=Brutal Tanzanite", "=ds=#e7#", "8.00%" },
        { 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=Imperial Tanzanite", "=ds=#e7#", "8.00%" },
        { 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=Mysterious Fire Opal", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28229, "INV_Chest_Cloth_25", "=q3=Incanter's Robe", "=ds=#s5#, #a1# (D3)", "4.00%" },
        { 28348, "INV_Helmet_15", "=q3=Moonglade Cowl", "=ds=#s1#, #a2# (D3)", "12.00%" },
        { 28349, "INV_Helmet_19", "=q3=Tidefury Helm", "=ds=#s1#, #a3# (D3)", "12.00%" },
        { 28228, "INV_Chest_Chain_03", "=q3=Beast Lord Curiass", "=ds=#s5#, #a3# (D3)", "20.00%" },
        { 28350, "INV_Helmet_20", "=q3=Warhelm of the Bold", "=ds=#s1#, #a4# (D3)", "16.00%" },
	};

    TKBotTrash = {
        { 24172, "INV_Scroll_05", "=q4=Design: Coronet of Verdant Flame", "=ds=#p12# (370) =q1=#n92#", "0.27%" },
	};

	----------------------------------
	--- Tempest Keep: The Arcatraz ---
	----------------------------------

    TKArcUnbound = {
        { 28373, "INV_Misc_Cape_14", "=q3=Cloak of Scintillating Auras", "=ds=#s4#", "17.13%" },
        { 28374, "INV_Shoulder_32", "=q3=Mana-Sphere Shoulderguards", "=ds=#s3#, #a1#", "20.35%" },
        { 28384, "INV_Boots_Chain_09", "=q3=Outland Striders", "=ds=#s12#, #a3#", "19.52%" },
        { 28375, "INV_Belt_23", "=q3=Rubium War-Girdle", "=ds=#s10#, #a4#", "14.38%" },
        { 28372, "Ability_Druid_HealingInstincts", "=q3=Idol of Feral Shadows", "=ds=#s16#, #w14#", "15.80%" },
	};

    TKArcUnboundHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Deadly Fire Opal", "=ds=#e7#", "0.18%" },
        { 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Nimble Fire Opal", "=ds=#e7#", "0.18%" },
        { 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Durable Fire Opal", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 28373, "INV_Misc_Cape_14", "=q3=Cloak of Scintillating Auras", "=ds=#s4#", "33.33%" },
        { 28374, "INV_Shoulder_32", "=q3=Mana-Sphere Shoulderguards", "=ds=#s3#, #a1#", "12.50%" },
        { 28384, "INV_Boots_Chain_09", "=q3=Outland Striders", "=ds=#s12#, #a3#", "16.67%" },
        { 28375, "INV_Belt_23", "=q3=Rubium War-Girdle", "=ds=#s10#, #a4#", "16.67%" },
        { 28372, "Ability_Druid_HealingInstincts", "=q3=Idol of Feral Shadows", "=ds=#s16#, #w14#", "8.33%" },
	};

    TKArcThirdFragmentGuardian = {
        { 24488, "INV_Misc_Key_02", "=q1=Third Key Fragment", "=ds=#m3#", "100%" },
	};
        
    TKArcScryer = {
        { 28396, "INV_Gauntlets_22", "=q3=Gloves of the Unbound", "=ds=#s9#, #a2#", "17.80%" },
        { 28398, "INV_Belt_26", "=q3=The Sleeper's Cord", "=ds=#s10#, #a2#", "16.29%" },
        { 28394, "INV_Jewelry_Ring_48Naxxramas", "=q3=Ryngo's Band of Ingenuity", "=ds=#s13#", "16.81%" },
        { 28393, "INV_Mace_42", "=q3=Warmaul of Infused Light", "=ds=#h2#, #w6#", "16.14%" },
        { 28397, "INV_Weapon_Crossbow_17", "=q3=Emberhawk Crossbow", "=ds=#w3#", "17.65%" },
	};

    TKArcScryerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Deadly Fire Opal", "=ds=#e7#", "0.18%" },
        { 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Nimble Fire Opal", "=ds=#e7#", "0.18%" },
        { 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Durable Fire Opal", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 28396, "INV_Gauntlets_22", "=q3=Gloves of the Unbound", "=ds=#s9#, #a2#", "20.59%" },
        { 28398, "INV_Belt_26", "=q3=The Sleeper's Cord", "=ds=#s10#, #a2#", "11.76%" },
        { 28394, "INV_Jewelry_Ring_48Naxxramas", "=q3=Ryngo's Band of Ingenuity", "=ds=#s13#", "23.53%" },
        { 28393, "INV_Mace_42", "=q3=Warmaul of Infused Light", "=ds=#h2#, #w6#", "14.71%" },
        { 28397, "INV_Weapon_Crossbow_17", "=q3=Emberhawk Crossbow", "=ds=#w3#", "8.82%" },
	};
        
    TKArcDalliah = {
        { 24308, "INV_Scroll_05", "=q4=Pattern: Whitemend Pants", "=ds=#p8# (375)", "0.29%" },
        { 0,"","","" },
        { 28391, "INV_Chest_Wolf", "=q3=Worldfire Chestguard", "=ds=#s5#, #a3#", "18.57%" },
        { 28390, "INV_Gauntlets_30", "=q3=Thatia's Self-Correcting Gauntlets", "=ds=#s9#, #a4#", "14.80%" },
        { 28387, "INV_Mace_13", "=q3=Lamp of Peaceful Repose", "=ds=#s15#", "15.92%" },
        { 28392, "INV_Weapon_Hand_08", "=q3=Reflex Blades", "=ds=#h3#, #w13#", "18.37%" },
        { 28386, "INV_Wand_17", "=q3=Nether Core's Control Rod", "#w12#", "15.29%" },
	};

    TKArcDalliahHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Deadly Fire Opal", "=ds=#e7#", "0.18%" },
        { 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Nimble Fire Opal", "=ds=#e7#", "0.18%" },
        { 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Durable Fire Opal", "=ds=#e7#", "0.18%" },
        { 24308, "INV_Scroll_05", "=q4=Pattern: Whitemend Pants", "=ds=#p8# (375)", "0.29%" },
        { 0,"","","" },
        { 28391, "INV_Chest_Wolf", "=q3=Worldfire Chestguard", "=ds=#s5#, #a3#", "14.29%" },
        { 28390, "INV_Gauntlets_30", "=q3=Thatia's Self-Correcting Gauntlets", "=ds=#s9#, #a4#", "20.00%" },
        { 28387, "INV_Mace_13", "=q3=Lamp of Peaceful Repose", "=ds=#s15#", "20.00%" },
        { 28392, "INV_Weapon_Hand_08", "=q3=Reflex Blades", "=ds=#h3#, #w13#", "11.43%" },
        { 28386, "INV_Wand_17", "=q3=Nether Core's Control Rod", "=ds=#w12#", "14.29%" },
	};

    TKArcHarbinger = {
        { 28406, "INV_Boots_Cloth_04", "=q3=Sigil-Laced Boots", "=ds=#s12#, #a1#", "12.23%" },
        { 28419, "INV_Jewelry_Necklace_30Naxxramas", "=q3=Choker of Fluid Thought", "=ds=#s2#", "14.92%" },
        { 28407, "INV_Jewelry_Ring_AhnQiraj_04", "=q3=Elementium Band of the Sentry", "=ds=#s13#", "10.70%" },
        { 28418, "INV_Gizmo_ElementalBlastingPowder", "=q3=Shiffar's Nexus-Horn", "=ds=#s14#", "12.23%" },
        { 28412, "INV_Offhand_OutlandRaid_03white", "=q3=Lamp of Peaceful Radiance", "=ds=#s15#", "13.15%" },
        { 28416, "INV_Weapon_Shortblade_35", "=q3=Hungering Spineripper", "=ds=#h1#, #w4#", "12.35%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28415, "INV_Helmet_30", "=q3=Hood of Oblivion", "=ds=#s1#, #a1# (D3)", "12.23%" },
        { 28413, "INV_Jewelry_Ring_62", "=q3=Hallowed Crown", "=ds=#s1#, #a1# (D3)", "12.17%" },
        { 28414, "INV_Helmet_15", "=q3=Helm of Assassination", "=ds=#s1#, #a2# (D3)", "11.25%" },
        { 28231, "INV_Chest_Chain_03", "=q3=Tidefury Chestpiece", "=ds=#s5#, #a3# (D3)", "14.98%" },
        { 28403, "INV_Chest_Chain_15", "=q3=Doomplate Chestguard", "=ds=#s5#, #a4# (D3)", "13.15%" },
        { 28205, "INV_Chest_Chain_15", "=q3=Breastplate of the Bold", "=ds=#s5#, #a4# (D3)", "11.19%" },
	};

    TKArcHarbingerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=Badge of Justice", "=ds=#e15#", "100%" },
        { 29248, "INV_Boots_Cloth_05", "=q4=Shadowstep Striders", "=ds=#s12#, #a2#", "0.61%" },
        { 30534, "INV_Pants_Mail_16", "=q4=Wyrmscale Greaves", "=ds=#s11#, #a3#", "0.49%" },
        { 29252, "INV_Bracer_02", "=q4=Bracers of Dignity", "=ds=#s8#, #a4#", "3.03%" },
        { 29254, "INV_Boots_Chain_05", "=q4=Boots of the Righteous Path", "=ds=#s12#, #a4#", "0.61%" },
        { 29360, "INV_Weapon_Shortblade_33", "=q4=Vileblade of the Betrayer", "=ds=#h1#, #w4#", "0.18%" },
        { 0,"","","" },
        { 28406, "INV_Boots_Cloth_04", "=q3=Sigil-Laced Boots", "=ds=#s12#, #a1#", "9.38%" },
        { 28419, "INV_Jewelry_Necklace_30Naxxramas", "=q3=Choker of Fluid Thought", "=ds=#s2#", "12.50%" },
        { 28407, "INV_Jewelry_Ring_AhnQiraj_04", "=q3=Elementium Band of the Sentry", "=ds=#s13#", "12.50%" },
        { 28418, "INV_Gizmo_ElementalBlastingPowder", "=q3=Shiffar's Nexus-Horn", "=ds=#s14#", "9.38%" },
        { 28412, "INV_Offhand_OutlandRaid_03white", "=q3=Lamp of Peaceful Radiance", "=ds=#s15#", "6.25%" },
        { 28416, "INV_Weapon_Shortblade_35", "=q3=Hungering Spineripper", "=ds=#h1#, #w4#", "3.12%" },
        { 0,"","","" },
        { 0,"","","" },
        { 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Deadly Fire Opal", "=ds=#e7#", "0.18%" },
        { 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Nimble Fire Opal", "=ds=#e7#", "0.18%" },
        { 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=Durable Fire Opal", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28415, "INV_Helmet_30", "=q3=Hood of Oblivion", "=ds=#s1#, #a1# (D3)", "18.75%" },
        { 28413, "INV_Jewelry_Ring_62", "=q3=Hallowed Crown", "=ds=#s1#, #a1# (D3)", "12.17%" },
        { 28414, "INV_Helmet_15", "=q3=Helm of Assassination", "=ds=#s1#, #a2# (D3)", "18.75%" },
        { 28231, "INV_Chest_Chain_03", "=q3=Tidefury Chestpiece", "=ds=#s5#, #a3# (D3)", "9.38%" },
        { 28403, "INV_Chest_Chain_15", "=q3=Doomplate Chestguard", "=ds=#s5#, #a4# (D3)", "12.50%" },
        { 28205, "INV_Chest_Chain_15", "=q3=Breastplate of the Bold", "=ds=#s5#, #a4# (D3)", "11.19%" },
	};

    TKArcTrash = {
        { 23606, "INV_Scroll_05", "=q3=Plans: Felsteel Leggings", "=ds=#p2# (360), =q1=#n57#", "3.93%" },
        { 0,"","","" },
        { 22556, "INV_Misc_Note_01", "=q2=Formula: Enchant 2H Weapon - Major Agility", "=ds=#p4# (360) =q1=#n89#", "1.68%" },
        { 29672, "INV_Scroll_06", "=q2=Pattern: Flame Armor Kit", "=ds=#p7# (340) =q1=#n91#", "1.84%" },
        { 21905, "INV_Scroll_06", "=q2=Pattern: Arcanoweave Bracers", "=ds=#p8# (350) =q1=#n90#", "1.21%" },
	};

	----------------
	--- Karazhan ---
	----------------

    KaraAttumen = {
        { 28477, "INV_Bracer_13", "=q4=Harbinger Bands", "=ds=#s8#, #a1#", "14.68%" },
        { 28507, "INV_Gauntlets_17", "=q4=Handwraps of Flowing Thought", "=ds=#s9#, #a1#", "12.44%" },
        { 28508, "INV_Gauntlets_17", "=q4=Gloves of Saintly Blessings", "=ds=#s9#, #a1#", "11.69%" },
        { 28453, "INV_Bracer_02", "=q4=Bracers of the White Stag", "=ds=#s8#, #a2#", "12.19%" },
        { 28506, "INV_Gauntlets_28", "=q4=Gloves of Dexterous Manipulation", "=ds=#s9#, #a2#", "14.68%" },
        { 28503, "INV_Bracer_02", "=q4=Whirlwind Bracers", "=ds=#s8#, #a3#", "9.20%" },
        { 28454, "INV_Bracer_02", "=q4=Stalker's War Bands", "=ds=#s8#, #a3#", "16.17%" },
        { 28502, "INV_Bracer_19", "=q4=Vambraces of Courage", "=ds=#s8#, #a4#", "10.70%" },
        { 28505, "INV_Gauntlets_25", "=q4=Gauntlets of Renewed Hope", "=ds=#s9#, #a4#", "10.95%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28509, "INV_Jewelry_Necklace_22", "=q4=Worgen Claw Necklace", "=ds=#s2#", "17.16%" },
        { 28510, "INV_Jewelry_Ring_31", "=q4=Spectral Band of Innervation", "=ds=#s13#", "10.70%" },
        { 28504, "INV_Weapon_Crossbow_18", "=q4=Steelhawk Crossbow", "=ds=#w3#", "12.44%" },
        { 30480, "Ability_Mount_Dreadsteed", "=q4=Fiery Warhorse's Reins", "=ds=#e12#", "0.25%" },
        { 0,"","","" },
        { 23809, "INV_Scroll_05", "=q3=Schematic: Stabilized Eternium Scope", "=ds=#p5# (375)", "1.00%" },    
	};

    KaraMoroes = {
        { 28529, "INV_Misc_Cape_10", "=q4=Royal Cloak of Arathi Kings", "=ds=#s4#", "15.91%" },
        { 28570, "INV_Misc_Cape_20", "=q4=Shadow-Cloak of Dalaran", "=ds=#s4#", "12.18%" },
        { 28565, "INV_Belt_08", "=q4=Nethershard Girdle", "=ds=#s10#, #a1#", "14.08%" },
        { 28545, "INV_Boots_Plate_06", "=q4=Edgewalker Longboots", "=ds=#s12#, #a2#", "11.07%" },
        { 28567, "INV_Belt_22", "=q4=Belt of Gale Force", "=ds=#s10#, #a3#", "12.05%" },
        { 28566, "INV_Belt_27", "=q4=Crimson Girdle of the Indomitable", "=ds=#s10#, #a4#", "10.81%" },
        { 28569, "INV_Boots_Chain_05", "=q4=Boots of Valiance", "=ds=#s12#, #a4#", "11.33%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28530, "INV_Jewelry_Necklace_AhnQiraj_04", "=q4=Brooch of Unquenchable Fury", "=ds=#s2#", "12.25%" },
        { 28528, "INV_Misc_PocketWatch_02", "=q4=Moroes' Lucky Pocket Watch", "=ds=#s14#", "12.05%" },
        { 28525, "INV_Jewelry_Ring_60", "=q4=Signet of Unshakable Faith", "=ds=#s15#", "14.54%" },
        { 28568, "INV_Misc_TheGoldenCheep", "=q4=Idol of the Avian Heart", "=ds=#s16#, #w14#", "14.08%" },
        { 28524, "INV_Weapon_Shortblade_38", "=q4=Emerald Ripper", "=ds=#h1#, #w4#", "12.90%" },
        { 0,"","","" },
        { 22559, "INV_Misc_Note_01", "=q3=Formula: Enchant Weapon - Mongoose", "=ds=#p4# (375)", "1.05%" },
	};

    KaraMaiden = {
        { 28511, "INV_Bracer_13", "=q4=Bands of Indwelling", "=ds=#s8#, #a1#", "12.46%" },
        { 28515, "INV_Bracer_13", "=q4=Bands of Nefarious Deeds", "=ds=#s8#, #a1#", "13.87%" },
        { 28517, "INV_Boots_Cloth_05", "=q4=Boots of Foretelling", "=ds=#s12#, #a1#", "16.96%" },
        { 28514, "INV_Bracer_15", "=q4=Bracers of Maliciousness", "=ds=#s8#, #a2#", "15.90%" },
        { 28521, "INV_Gauntlets_25", "=q4=Mitts of the Treemender", "=ds=#s9#, #a2#", "13.16%" },
        { 28520, "INV_Gauntlets_25", "=q4=Gloves of Centering", "=ds=#s9#, #a3#", "13.16%" },
        { 28519, "INV_Gauntlets_25", "=q4=Gloves of Quickening", "=ds=#s9#, #a3#", "14.22%" },
        { 28512, "INV_Bracer_02", "=q4=Bracers of Justice", "=ds=#s8#, #a4#", "10.42%" },
        { 28518, "INV_Gauntlets_31", "=q4=Iron Gauntlets of the Maiden", "=ds=#s9#, #a4#", "12.63%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28516, "INV_Jewelry_Necklace_AhnQiraj_02", "=q4=Barbed Choker of Discipline", "=ds=#s2#", "11.48%" },
        { 28523, "Spell_Nature_GiftoftheWaterSpirit", "=q4=Totem of Healing Rains", "=ds=#s16#, #w15#", "14.58%" },
        { 28522, "INV_Hammer_26", "=q4=Shard of the Virtuous", "=ds=#h3#, #w6#", "10.69%" },
	};
        
    KaraOperaEvent = {
        { 0, "INV_Box_01", "=q6="..AL["Shared Drops"], "" },
        { 28594, "INV_Pants_Cloth_05", "=q4=Trial-FireTrousers", "=ds=#s11#, #a1#", "15.96%" },
        { 28591, "INV_Pants_Mail_15", "=q4=Earthsoul Leggings", "=ds=#s11#, #a2#", "12.45%" },
        { 28589, "INV_Shoulder_36", "=q4=Beastmaw Pauldrons", "=ds=#s3#, #a3#", "12.54%" },
        { 28593, "INV_Helmet_03", "=q4=Eternium Greathelm", "=ds=#s1#, #a4#", "11.53%" },
        { 28590, "INV_Misc_Bandage_16", "=q4=Ribbon of Sacrifice", "=ds=#s14#", "18.41%" },
        { 28592, "INV_Relics_LibramofGrace", "=q4=Libram of Souls Redeemed", "=ds=#s16#, #w16#", "8.38%" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6="..BabbleBoss["The Crone"], "=q5="..AL["Wizard of Oz"] },
        { 28586, "INV_Helmet_30", "=q4=Wicked Witch's Hat", "=ds=#s1#, #a1#", "20.12%" },
        { 28585, "INV_Boots_Cloth_09", "=q4=Ruby Slippers", "=ds=#s12#, #a1#", "25.39%" },
        { 28587, "INV_Axe_46", "=q4=Legacy", "=ds=#h2#, #w1#", "20.43%" },
        { 28588, "INV_Wand_16", "=q4=Blue Diamond Witchwand", "=ds=#w12#", "17.96%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6="..BabbleBoss["Romulo & Julianne"], "=q5="..AL["Romulo & Julianne"] },
        { 28578, "INV_Chest_Cloth_43", "=q4=Masquerade Gown", "=ds=#s5#, #a1#", "22.73%" },
        { 28579, "INV_Poison_MindNumbing", "=q4=Romeo's Poison Vial", "=ds=#s14#", "29.54%" },
        { 28572, "INV_Weapon_Shortblade_39", "=q4=Blade of the Unrequited", "=ds=#h1#, #w4#", "13.52%" },
        { 28573, "INV_Sword_69", "=q4=Despair", "=ds=#h2#, #w10#", "30.07%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6="..BabbleBoss["The Big Bad Wolf"], "=q5="..AL["Red Riding Hood"] },
        { 28582, "INV_Misc_Cape_18", "=q4=Red Riding Hood's Cloak", "=ds=#s4#", "12.85%" },
        { 28583, "INV_Helmet_04", "=q4=Big Bad Wolf's Head", "=ds=#s1#, #a3#", "16.37%" },
        { 28584, "INV_Misc_MonsterClaw_04", "=q4=Big Bad Wolf's Paw", "=ds=#h3#, #w13#", "16.12%" },
        { 28581, "INV_Weapon_Rifle_23", "=q4=Wolfslayer Sniper Rifle", "=ds=#w5#", "22.42%" },
	};

    KaraCurator = {
        { 28612, "INV_Shoulder_25", "=q4=Pauldrons of the Solace-Giver", "=ds=#s3#, #a1#", "15.19%" },
        { 28647, "INV_Shoulder_01", "=q4=Forest Wind Shoulderpads", "=ds=#s3#, #a2#", "10.56%" },
        { 28631, "INV_Shoulder_14", "=q4=Dragon-Quake Shoulderguards", "=ds=#s3#, #a3#", "13.47%" },
        { 28621, "INV_Pants_Plate_05", "=q4=Wrynn Dynasty Greaves", "=ds=#s11#, #a4#", "11.85%" },
        { 28649, "INV_Jewelry_Ring_47", "=q4=Garona's Signet Ring", "=ds=#s13#", "12.07%" },
        { 28633, "INV_Weapon_Halberd17", "=q4=Staff of Infinite Mysteries", "=ds=#w9#", "12.28%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29757, "INV_Gauntlets_27", "=q4=Gloves of the Fallen Champion", "=ds=#m21# #e15#", "29.42%" },
        { 29758, "INV_Gauntlets_27", "=q4=Gloves of the Fallen Defender", "=ds=#m21# #e15#", "23.60%" },
        { 29756, "INV_Gauntlets_27", "=q4=Gloves of the Fallen Hero", "=ds=#m21# #e15#", "21.66%" },
	};

    KaraIllhoof = {
        { 28660, "INV_Misc_Cape_20", "=q4=Gilded Thorium Cloak", "=ds=#s4#", "14.63%" },
        { 28653, "INV_Misc_Cape_05", "=q4=Shadowvine Cloak of Infusion", "=ds=#s4#", "10.45%" },
        { 28652, "INV_Belt_08", "=q4=Cincture of Will", "=ds=#s10#, #a1#", "10.75%" },
        { 28654, "INV_Belt_03", "=q4=Malefic Girdle", "=ds=#s10#, #a1#", "11.04%" },
        { 28655, "INV_Belt_22", "=q4=Cord of Nature's Sustenance", "=ds=#s10#, #a2#", "14.93%" },
        { 28656, "INV_Belt_22", "=q4=Girdle of the Prowler", "=ds=#s10#, #a3#", "17.91%" },
        { 28662, "INV_Chest_Plate03", "=q4=Breastplate of the Lightbinder", "=ds=#s5#, #a4#", "17.31%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28661, "INV_Jewelry_Ring_36", "=q4=Mender's Heart-Ring", "=ds=#s13#", "11.64%" },
        { 28785, "INV_Trinket_Naxxramas06", "=q4=The Lightning Capacitor", "=ds=#s14#", "10.75%" },
        { 28657, "INV_Weapon_Shortblade_44", "=q4=Fool's Bane", "=ds=#h3#, #w6#", "14.63%" },
        { 28658, "INV_Staff_55", "=q4=Terestian's Stranglestaff", "=ds=#w9#", "7.46%" },
        { 28659, "INV_Weapon_Shortblade_35", "=q4=Xavian Stiletto", "=ds=#w11#", "13.43%" },
        { 0,"","","" },
        { 22561, "INV_Misc_Note_01", "=q3=Formula: Enchant Weapon - Soulfrost", "=ds=#p4# (375)", "0.30%" },
	};

    KaraAran = {
        { 28672, "INV_Misc_Cape_10", "=q4=Drape of the Dark Reavers", "=ds=#s4#", "11.70%" },
        { 28726, "INV_Shoulder_25", "=q4=Mantle of the Mind Flayer", "=ds=#s3#, #a1#", "16.03%" },
        { 28670, "INV_Boots_05", "=q4=Boots of the Infernal Coven", "=ds=#s12#, #a1#", "9.29%" },
        { 28663, "INV_Boots_Fabric_01", "=q4=Boots of the Incorrupt", "=ds=#s12#, #a1#", "12.72%" },
        { 28669, "INV_Boots_Plate_06", "=q4=Rapscallion Boots", "=ds=#s12#, #a2#", "11.32%" },
        { 28671, "INV_Helmet_05", "=q4=Steelspine Faceguard", "=ds=#s1#, #a3#", "12.21%" },
        { 28666, "INV_Shoulder_35", "=q4=Pauldrons of the Justice-Seeker", "=ds=#s3#, #a4#", "11.58%" },
        { 0,"","","" },
        { 23933, "INV_Misc_Book_06", "=q1=Medivh's Journal", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28674, "INV_Jewelry_Necklace_34", "=q4=Saberclaw Talisman", "=ds=#s2#", "11.20%" },
        { 28675, "INV_Jewelry_Ring_19", "=q4=Shermanar Great-Ring", "=ds=#s13#", "10.43%" },
        { 28727, "INV_Trinket_Naxxramas02", "=q4=Pendant of the Violet Eye", "=ds=#s14#", "15.39%" },
        { 28728, "INV_Misc_Gem_Sapphire_02", "=q4=Aran's Soothing Sapphire", "=ds=#s15#", "12.72%" },
        { 28673, "INV_Wand_21", "=q4=Tirisfal Wand of Ascendancy", "=ds=#w12#", "7.25%" },
        { 0,"","","" },
        { 22560, "INV_Misc_Note_01", "=q3=Formula: Enchant Weapon - Sunfire", "=ds=#p4# (375)", "0.76%" },
	};

    KaraNetherspite = {
        { 28744, "INV_Helmet_53", "=q4=Uni-Mind Headdress", "=ds=#s1#, #a1#", "12.91%" },
        { 28742, "INV_Pants_Cloth_13", "=q4=Pantaloons of Repentence", "=ds=#s11#, #a1#", "10.99%" },
        { 28732, "INV_Helmet_58", "=q4=Cowl of Defiance", "=ds=#s1#, #a2#", "17.31%" },
        { 28741, "INV_Pants_Leather_13", "=q4=Skulker's Greaves", "=ds=#s11#, #a2#", "15.38%" },
        { 28735, "INV_Chest_Plate08", "=q4=Earthblood Chestguard", "=ds=#s5#, #a3#", "15.93%" },
        { 28740, "INV_Pants_Plate_02", "=q4=Rip-Flayer Leggings", "=ds=#s11#, #a3#", "10.16%" },
        { 28743, "INV_Shoulder_29", "=q4=Mantle of Abrahmis", "=ds=#s3#, #a4#", "9.34%" },
        { 28733, "INV_Belt_22", "=q4=Girdle of Truth", "=ds=#s10#, #a4#", "10.44%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28731, "INV_Jewelry_Necklace_32", "=q4=Shining Chain of the Afterworld", "=ds=#s2#", "15.11%" },
        { 28730, "INV_Jewelry_Ring_24", "=q4=Mithril Band of the Unscarred", "=ds=#s13#", "10.99%" },
        { 28734, "INV_Misc_Gem_EbonDraenite_02", "=q4=Jewel of Infinite Possibilities", "=ds=#s15#", "11.64%" },
        { 28729, "INV_Sword_74", "=q4=Spiteblade", "=ds=#h1#, #w10#", "6.32%" },
	};

    KaraChess = {
        { 28756, "INV_Crown_01", "=q4=Headdress of the High Potentate", "=ds=#s1#, #a1#", "17.98%" },
        { 28755, "INV_Shoulder_29", "=q4=Bladed Shoulderpads of the Merciless", "=ds=#s3#, #a2#", "13.55%" },
        { 28750, "INV_Belt_26", "=q4=Girdle of Treachery", "=ds=#s10#, #a2#", "15.02%" },
        { 28752, "INV_Boots_Chain_05", "=q4=Forestlord Striders", "=ds=#s12#, #a2#", "14.04%" },
        { 28751, "INV_Pants_Mail_15", "=q4=Heart-Flame Leggings", "=ds=#s11#, #a3#", "12.56%" },
        { 28746, "INV_Boots_Chain_05", "=q4=Fiend Slayer Boots", "=ds=#s12#, #a3#", "16.26%" },
        { 28748, "INV_Pants_Plate_18", "=q4=Legplates of the Innocent", "=ds=#s11#, #a4#", "13.79%" },
        { 28747, "INV_Boots_Plate_06", "=q4=Battlescar Boots", "=ds=#s12#, #a4#", "13.79%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28745, "INV_Jewelry_Necklace_06", "=q4=Mithril Chain of Heroism", "=ds=#s2#", "12.81%" },
        { 28753, "INV_Jewelry_Ring_15", "=q4=Ring of Recurrence", "=ds=#s13#", "12.56%" },
        { 28749, "INV_Sword_74", "=q4=King's Defender", "=ds=#h1#, #w10#", "12.07%" },
        { 28754, "INV_Shield_31", "=q4=Triptych Shield of the Ancients", "=ds=#w8#", "13.30%" },
	};

    KaraNightbane = {
        { 28602, "INV_Chest_Cloth_12", "=q4=Robe of the Elder Scribes", "=ds=#s5#, #a1#", "17.38%" },
        { 28600, "INV_Chest_Leather_07", "=q4=Stonebough Jerkin", "=ds=#s5#, #a2#", "13.33%" },
        { 28601, "INV_Chest_Leather_06", "=q4=Chestguard of the Conniver", "=ds=#s5#, #a2#", "10.24%" },
        { 28599, "INV_Chest_Chain_07", "=q4=Scaled Breastplate of Carnage", "=ds=#s5#, #a3#", "11.67%" },
        { 28610, "INV_Boots_Chain_04", "=q4=Ferocious Swift-Kickers", "=ds=#s12#, #a3#", "15.71%" },
        { 28597, "INV_Chest_Plate02", "=q4=Panzar'Thar Breastplate", "=ds=#s5#, #a4#", "10.00%" },
        { 28608, "INV_Boots_Plate_04", "=q4=Ironstriders of Urgency", "=ds=#s12#, #a4#", "9.05%" },
        { 0,"","","" },
        { 31751, "Spell_Fire_Burnout", "=q1=Blazing Signet", "=ds=#m3#", "100%" },
        { 24139, "INV_Enchant_EssenceMagicSmall", "=q1=Faint Arcane Essence", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28609, "INV_Jewelry_Necklace_17", "=q4=Emberspur Talisman", "=ds=#s2#", "13.33%" },
        { 28603, "INV_Offhand_OutlandRaid_01", "=q4=Talisman of Nightbane", "=ds=#s15#", "12.62%" },
        { 28604, "INV_Staff_57", "=q4=Nightstaff of the Everliving", "=ds=#w9#", "16.67%" },
        { 28611, "INV_Shield_37", "=q4=Dragonheart Flameshield", "=ds=#w8#", "13.57%" },
        { 28606, "INV_Shield_29", "=q4=Shield of Impenetrable Darkness", "=ds=#w8#", "12.14%" },
	};

    KaraPrince = {
        { 28765, "INV_Misc_Cape_06", "=q4=Stainless Cloak of the Pure Hearted", "=ds=#s4#", "10.37%" },
        { 28766, "INV_Misc_Cape_18", "=q4=Ruby Drape of the Mysticant", "=ds=#s4#", "12.50%" },
        { 28764, "INV_Misc_Cape_17", "=q4=Farstrider Wildercloak", "=ds=#s4#", "15.96%" },
        { 28762, "INV_Jewelry_Necklace_29Naxxramas", "=q4=Adornment of Stolen Souls", "=ds=#s2#", "9.57%" },
        { 28763, "INV_Jewelry_Ring_08", "=q4=Jade Ring of the Everliving", "=ds=#s13#", "11.84%" },
        { 28757, "INV_Jewelry_Ring_AhnQiraj_05", "=q4=Ring of a Thousand Marks", "=ds=#s13#", "12.90%" },
        { 28770, "INV_Weapon_Shortblade_41", "=q4=Nathrezim Mindblade", "=ds=#h3#, #w4#", "10.64%" },
        { 28768, "INV_Weapon_Shortblade_40", "=q4=Malchazeen", "=ds=#h1#, #w4#", "9.84%" },
        { 28767, "INV_Axe_66", "=q4=The Decapitator", "=ds=#h3#, #w1#", "15.43%" },
        { 28773, "INV_Axe_60", "=q4=Gorehowl", "=ds=#h2#, #w1#", "12.63%" },
        { 28771, "INV_Mace_46", "=q4=Light's Justice", "=ds=#h3#, #w6#", "11.17%" },
        { 28772, "INV_Weapon_Bow_18", "=q4=Sunfury Bow of the Phoenix", "=ds=#w2#", "9.97%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29760, "INV_Helmet_24", "=q4=Helm of the Fallen Champion", "=ds=#m21# #e15#", "23.01%" },
        { 29761, "INV_Helmet_24", "=q4=Helm of the Fallen Defender", "=ds=#m21# #e15#", "26.73%" },
        { 29759, "INV_Helmet_24", "=q4=Helm of the Fallen Hero", "=ds=#m21# #e15#", "20.48%" },
	};

    KaraTrash = {
        { 30642, "INV_Misc_Cape_18", "=q4=Drape of the Righteous", "=ds=#s4#", "0.22%" },
        { 30668, "INV_Gauntlets_17", "=q4=Grasp of the Dead", "=ds=#s9#, #a1#", "0.17%" },
        { 30673, "INV_Belt_03", "=q4=Inferno Waist Cord", "=ds=#s10#, #a1#", "0.21%" },
        { 30644, "INV_Gauntlets_28", "=q4=Grips of the Deftness", "=ds=#s9#, #a2#", "0.23%" },
        { 30674, "INV_Boots_Plate_06", "=q4=Zierhut's Lost Treads", "=ds=#s12#, #a2#", "0.17%" },
        { 30643, "INV_Belt_22", "=q4=Belt of the Tracker", "=ds=#s10#, #a3#", "0.19%" },
        { 30641, "INV_Boots_Plate_04", "=q4=Boots of Elusion", "=ds=#s12#, #a4#", "0.13%" },
        { 0,"","","" },
        { 21882, "Spell_Shadow_SoulLeech_3", "=q1=Soul Essence", "=ds=#e8#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30666, "INV_Jewelry_Necklace_30Naxxramas", "=q4=Rittsyn's Lost Pendant", "=ds=#s2#", "0.18%" },
        { 30667, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of Unrelenting Storms", "=ds=#s13#", "0.17%" },
        { 0,"","","" },
        { 21903, "INV_Scroll_04", "=q4=Pattern: Soulcloth Shoulders", "=ds=#p8# (375)", "0.74%" },
        { 21904, "INV_Scroll_04", "=q4=Pattern: Soulcloth Vest", "=ds=#p8# (375)", "1.07%" },
        { 22545, "INV_Misc_Note_01", "=q2=Formula: Enchant Boots - Surefooted", "=ds=#p4# (370)", "0.66%" },
	};

    KaraNamed = {
        { 0, "Ability_Hunter_Pet_Spider", "=q6="..BabbleBoss["Hyakiss the Lurker"], "=q5="..AL["Spider"] },
        { 30675, "INV_Belt_03", "=q4=Lurker's Cord", "=ds=#s10#, #a1# =q2=#m16#", "32.81%" },
        { 30676, "INV_Belt_25", "=q4=Lurker's Grasp", "=ds=#s10#, #a2# =q2=#m16#", "9.38%" },
        { 30677, "INV_Belt_03", "=q4=Lurker's Belt", "=ds=#s10#, #a3# =q2=#m16#", "23.44%" },
        { 30678, "INV_Belt_22", "=q4=Lurker's Girdle", "=ds=#s10#, #a4# =q2=#m16#", "15.62%" },
        { 0,"","","" },
        { 0, "Ability_Hunter_Pet_Hyena", "=q6="..BabbleBoss["Rokad the Ravager"], "=q5="..AL["Darkhound"] },
        { 30684, "INV_Bracer_10", "=q4=Ravager's Cuffs", "=ds=#s8#, #a1# =q2=#m16#", "27.78%" },
        { 30685, "INV_Bracer_07", "=q4=Ravager's Wrist-Wraps", "=ds=#s8#, #a2# =q2=#m16#", "11.11%" },
        { 30686, "INV_Bracer_02", "=q4=Ravager's Bands", "=ds=#s8#, #a3# =q2=#m16#", "23.33%" },
        { 30687, "INV_Bracer_07", "=q4=Ravager's Bracers", "=ds=#s8#, #a4# =q2=#m16#", "8.89%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Ability_Hunter_Pet_Bat", "=q6="..BabbleBoss["Shadikith the Glider"], "=q5="..AL["Bat"] },
        { 30680, "INV_Boots_05", "=q4=Glider's Foot-Wraps", "=ds=#s12#, #a1# =q2=#m16#", "9.68%" },
        { 30681, "INV_Boots_05", "=q4=Glider's Boots", "=ds=#s12#, #a2# =q2=#m16#", "22.58%" },
        { 30682, "INV_Boots_Chain_05", "=q4=Glider's Sabatons", "=ds=#s12#, #a3# =q2=#m16#", "9.68%" },
        { 30683, "INV_Boots_Plate_04", "=q4=Glider's Greaves", "=ds=#s12#, #a4# =q2=#m16#", "8.60%" },
	};

	--------------------
	--- Gruul's Lair ---
	--------------------

    GruulsLairHighKingMaulgar = {
        { 28797, "INV_Misc_Cape_16", "=q4=Brute Cloak of the Ogre-Magi", "#s4#", "8.39%" },
        { 28799, "INV_Belt_03", "=q4=Belt of Divine Inspiration", "#s10#, #a1#", "9.98%" },
        { 28796, "INV_Helmet_58", "=q4=Malefic Mask of the Shadows", "=ds=#s1#, #a2#", "12.93%" },
        { 28801, "INV_Helmet_23", "=q4=Maulgar's Warhelm", "=ds=#s1#, #a3#", "21.32%" },
        { 28795, "INV_Bracer_15", "=q4=Bladespire Warbands", "=ds=#s8#, #a4#", "12.02%" },
        { 28800, "INV_Hammer_28", "=q4=Hammer of the Naaru", "=ds=#h2#, #w6#", "15.87%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29763, "INV_Shoulder_22", "=q4=Pauldrons of the Fallen Champion", "=ds=#m21# #e15#", "22.68%" },
        { 29764, "INV_Shoulder_22", "=q4=Pauldrons of the Fallen Defender", "=ds=#m21# #e15#", "34.69%" },
        { 29762, "INV_Shoulder_22", "=q4=Pauldrons of the Fallen Hero", "=ds=#m21# #e15#", "25.62%" },
	};

    GruulGruul = {
        { 28804, "INV_Helmet_27", "=q4=Collar of Cho'gall", "=ds=#s1#, #a1#", "14.96%" },
        { 28803, "INV_Helmet_15", "=q4=Cowl of Nature's Breath", "=ds=#s1#, #a2#", "14.21%" },
        { 28828, "INV_Belt_26", "=q4=Gronn-Stitched Girdle", "=ds=#s10#, #a2#", "11.22%" },
        { 28827, "INV_Gauntlets_25", "=q4=Gauntlets of the Dragonslayer", "=ds=#s9#, #a3#", "7.48%" },
        { 28810, "INV_Boots_Chain_05", "=q4=Windshear Boots", "=ds=#s12#, #a3#", "10.22%" },
        { 28824, "INV_Gauntlets_31", "=q4=Gauntlets of Martial Perfection", "=ds=#s9#, #a4#", "12.22%" },
        { 28822, "INV_Misc_Bone_09", "=q4=Teeth of Gruul", "=ds=#s2#", "11.47%" },
        { 28823, "Spell_Shadow_UnholyFrenzy", "=q4=Eye of Gruul", "=ds=#s14#", "6.73%" },
        { 28830, "INV_Misc_Bone_03", "=q4=Dragonspine Trophy", "=ds=#s14#", "11.72%" },
        { 0,"","","" },
        { 31750, "INV_Ore_Thorium_01", "=q1=Earthen Signet", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29766, "INV_Pants_Plate_17", "=q4=Leggings of the Fallen Champion", "=ds=#m21# #e15#", "23.69%" },
        { 29767, "INV_Pants_Plate_17", "=q4=Leggings of the Fallen Defender", "=ds=#m21# #e15#", "17.46%" },
        { 29765, "INV_Pants_Plate_17", "=q4=Leggings of the Fallen Hero", "=ds=#m21# #e15#", "30.17%" },
        { 0,"","","" },
        { 28802, "INV_Sword_65", "=q4=Bloodmaw Magus-Blade", "=ds=#h3#, #w10#", "9.23%" },
        { 28794, "INV_Axe_64", "=q4=Axe of the Gronn Lords", "=ds=#h2#, #w1#", "6.73%" },
        { 28825, "INV_Shield_30", "=q4=Aldori Legacy Defender", "=ds=#w8#", "2.99%" },
        { 28826, "INV_Misc_AhnQirajTrinket_03", "=q4=Shuriken of Negation", "=ds=#w11#", "16.21%" },
	};

	--------------------------------------------
	--- Hellfire Citadel: Magtheridon's Lair ---
	--------------------------------------------

    HCMagtheridon = {
        { 28777, "INV_Misc_Cape_14", "=q4=Cloak of the Pit Stalker", "=ds=#s4#" },
        { 28780, "INV_Gauntlets_15", "=q4=Soul-Eater's Handwraps", "=ds=#s9#, #a1#" },
        { 28776, "INV_Gauntlets_19", "=q4=Liar's Tongue Gloves", "=ds=#s9#, #a2#" },
        { 28778, "INV_Belt_20", "=q4=Terror Pit Girdle", "=ds=#s10#, #a3#" },
        { 28775, "INV_Helmet_58", "=q4=Thundering Greathelm", "=ds=#s1#, #a4#" },
        { 28779, "INV_Belt_22", "=q4=Girdle of Endless Pit", "=ds=#s10#, #a4#" },
        { 28789, "INV_Elemental_Mote_Life01", "=q4=Eye of Magtheridon", "=ds=#s14#" },
        { 28781, "INV_Offhand_Draenei_A_01", "=q4=Karaborian Talisman", "=ds=#s15#" },
        { 0,"","","" },
        { 28774, "INV_Weapon_Halberd16", "=q4=Glaive of the Pit", "=ds=#w7#" },
        { 28782, "INV_Staff_53", "=q4=Crystalheart Pulse-Staff", "=ds=#w9#" },
        { 29458, "INV_Shield_33", "=q4=Aegis of the vindicator", "=ds=#w8#" },
        { 28783, "INV_Wand_20", "=q4=Eredar Wand of Obliteration", "=ds=#w12#" },
        { 0,"","","" },
        { 0,"","","" },
        { 29754, "INV_Chest_Chain_03", "=q4=Chestguard of the Fallen Champion", "=ds=#m21# #e15#" },
        { 29753, "INV_Chest_Chain_03", "=q4=Chestguard of the Fallen Defender", "=ds=#m21# #e15#" },
        { 29755, "INV_Chest_Chain_03", "=q4=Chestguard of the Fallen Hero", "=ds=#m21# #e15#" },
        { 0,"","","" },
        { 32385, "INV_Misc_Head_Tauren_01", "=q4=Magtheridon's Head", "=ds=#m2#", "100%" },
        { 28791, "INV_Jewelry_Ring_71", "=q4=Ring of the Recalcitrant", "=q1=#m4#: =ds=#s13#" },
        { 28790, "INV_Jewelry_Ring_70", "=q4=Naaru Lightwarden's Band", "=q1=#m4#: =ds=#s13#" },
        { 28793, "INV_Jewelry_Ring_65", "=q4=Band of Crimson Fury", "=q1=#m4#: =ds=#s13#" },
        { 28792, "Inv_Jewelry_Ring_55", "=q4=A'dal's Signet of Defense", "=q1=#m4#: =ds=#s13#" },
	};
 
	------------------------------------------------
	--- Coilfang Reservoir: Serpentshrine Cavern ---
	------------------------------------------------

    CFRSerpentHydross = {
        { 30056, "INV_Chest_Cloth_43", "=q4=Robe of Hateful Echoes", "=ds=#s5#, #a1#" },
        { 32516, "Inv_Bracer_13", "=q4=Wraps of Purification", "=ds=#s8#, #a1#" },
        { 30050, "INV_Boots_05", "=q4=Boots of the Shifting Nightmare", "=ds=#s12#, #a1#" },
        { 30055, "INV_Shoulder_23", "=q4=Shoulderpads of the Stranger", "=ds=#s3#, #a2#" },
        { 30047, "INV_Bracer_02", "=q4=Blackfathom Warbands", "=ds=#s8#, #a3#" },
        { 30054, "INV_Chest_Plate09", "=q4=Ranger-General's Chestguard", "=ds=#s5#, #a3#" },
        { 30048, "INV_Helmet_25", "=q4=Brighthelm of Justice", "=ds=#s1#, #a4#" },
        { 30053, "INV_Shoulder_20", "=q4=Pauldrons of the Wardancer", "=ds=#s3#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30052, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ring of Lethality", "=ds=#s13#" },
        { 33055, "INV_Jewelry_Ring_71", "=q4=Band of Vile Aggression", "=ds=#s13#" },
        { 30664, "INV_Misc_Herb_Nightmarevine", "=q4=Living Root of the Wildheart", "=ds=#s14#, =q1=#m1# =ds=#c1#" },
        { 30629, "INV_Trinket_Naxxramas05", "=q4=Scarab of Displacement", "=ds=#s14#" },
        { 30049, "INV_Misc_Gem_AzureDraenite_02", "=q4=Fathomstone", "=ds=#s15#" },
        { 30051, "INV_QirajIdol_Night", "=q4=Idol of the Crescent Goddess", "=ds=#s16#, #w14#" },
	};

    CFRSerpentLeotheras = {
        { 30092, "INV_Boots_Cloth_16", "=q4=Orca-Hide Boots", "=ds=#s12#, #a2#" },
        { 30097, "INV_Shoulder_19", "=q4=Coral-Barbed Shoulderpads", "=ds=#s3#, #a3#" },
        { 30091, "INV_Bracer_15", "=q4=True-Aim Stalker Bands", "=ds=#s8#, #a3#" },
        { 30096, "INV_Belt_27", "=q4=Girdle of the Invulnerable", "=ds=#s10#, #a4#" },
        { 30627, "Spell_Nature_UnrelentingStorm", "=q4=Tsunami Talisman", "=ds=#s14#" },
        { 30095, "INV_Sword_73", "=q4=Fang of the Leviathan", "=ds=#h3#, #w10#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30239, "INV_Gauntlets_27", "=q4=Gloves of the Vanquished Champion", "=ds=#m22# #e15#" },
        { 30240, "INV_Gauntlets_27", "=q4=Gloves of the Vanquished Defender", "=ds=#m22# #e15#" },
        { 30241, "INV_Gauntlets_27", "=q4=Gloves of the Vanquished Hero", "=ds=#m22# #e15#" },
	};

    CFRSerpentKarathress = {
        { 30100, "INV_Boots_Fabric_01", "=q4=Soul-Strider Boots", "=ds=#s12#, #a1#" },
        { 30101, "INV_Chest_Plate08", "=q4=Bloodsea Brigand's Vest", "=ds=#s5#, #a2#" },
        { 30099, "INV_Misc_Noose_01", "=q4=Frayed Tether of the Drowned", "=ds=#s2#" },
        { 30663, "INV_Misc_QirajiCrystal_04", "=q4=Fathom-Brooch of the Tidewalker", "=ds=#s14#, =q1=#m1# =ds=#c7#" },
        { 30626, "INV_Gizmo_09", "=q4=Sextant of Unstable Currents", "=ds=#s14#" },
        { 30090, "INV_Mace_52", "=q4=World Breaker", "=ds=#h2#, #w6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30245, "INV_Pants_Plate_17", "=q4=Leggings of the Vanquished Champion", "=ds=#m22# #e15#" },
        { 30246, "INV_Pants_Plate_17", "=q4=Leggings of the Vanquished Defender", "=ds=#m22# #e15#" },
        { 30247, "INV_Pants_Plate_17", "=q4=Leggings of the Vanquished Hero", "=ds=#m22# #e15#" },
	};

    CFRSerpentMorogrim = {
        { 30098, "INV_Misc_Cape_20", "=q4=Razor-Scale Battlecloak", "=ds=#s4#" },
        { 30079, "INV_Shoulder_25", "=q4=Illidari Shoulderpads", "=ds=#s3#, #a1#" },
        { 30075, "INV_Chest_Leather_10", "=q4=Gnarled Chestpiece of the Ancients", "=ds=#s5#, #a2#" },
        { 30085, "INV_Shoulder_27", "=q4=Mantle of the Tireless Tracker", "=ds=#s3#, #a3#" },
        { 30068, "INV_Belt_19", "=q4=Girdle of the Tidal Call", "=ds=#s10#, #a3#" },
        { 30084, "INV_Shoulder_22", "=q4=Pauldrons of the Argent Sentinel", "=ds=#s3#, #a4#" },
        { 30081, "INV_Boots_Plate_04", "=q4=Warboots of Obliteration", "=ds=#s12#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30008, "INV_Jewelry_Necklace_12", "=q4=Pendant of the Lost Ages", "=ds=#s2#" },
        { 30083, "INV_Jewelry_Ring_31", "=q4=Ring of Sundered Souls", "=ds=#s13#" },
        { 33058, "INV_Jewelry_Ring_43", "=q4=Band of the Vigilant", "=ds=#s13#" },
        { 30720, "Spell_Nature_PoisonCleansingTotem", "=q4=Serpent-Coil Braid", "=ds=#s14#, =q1=#m1# =ds=#c3#" },
        { 30082, "INV_Sword_50", "=q4=Talon of Azshara", "=ds=#h1#, #w10#" },
        { 30080, "INV_Wand_15", "=q4=Luminescent Rod of the Naaru", "=ds=#w12#" },
	};

    CFRSerpentLurker = {
        { 30064, "INV_Belt_03", "=q4=Cord of Screaming Terrors", "=ds=#s10#, #a1#" },
        { 30067, "INV_Boots_05", "=q4=Velvet Boots of the Guardian", "=ds=#s12#, #a1#" },
        { 30062, "INV_Bracer_02", "=q4=Grove-Bands of Remulos", "=ds=#s8#, #a2#" },
        { 30060, "INV_Boots_Plate_06", "=q4=Boots of Effortless Striking", "=ds=#s12#, #a2#" },
        { 30066, "INV_Boots_Chain_05", "=q4=Tempest-Strider Boots", "=ds=#s12#, #a3#" },
        { 30065, "INV_Chest_Plate05", "=q4=Glowing Breastplate of Truth", "=ds=#s5#, #a4#" },
        { 30057, "INV_Bracer_19", "=q4=Bracers of Eradication", "=ds=#s8#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30059, "INV_Jewelry_Necklace_AhnQiraj_03", "=q4=Choker of Animalistic Fury", "=ds=#s2#" },
        { 30061, "INV_Jewelry_Ring_41", "=q4=Ancestral Ring of Conquest", "=ds=#s13#" },
        { 33054, "INV_Jewelry_Ring_39", "=q4=The Seal of Danzalar", "=ds=#s13#" },
        { 30665, "INV_Jewelry_Ring_07", "=q4=Earring of Soulful Meditation", "=ds=#s14#, =q1=#m1# =ds=#c5#" },
        { 30063, "INV_Relics_LibramofTruth", "=q4=Libram of Absolute Truth", "=ds=#s16#, #w16#" },
        { 30058, "INV_Weapon_Shortblade_42", "=q4=Mallet of the Tides", "=ds=#h3#, #w6#" },
	};

    CFRSerpentVashj = {
        { 30107, "INV_Chest_Cloth_17", "=q4=Vestments of the Sea-Witch", "=ds=#s5#, #a1#" },
        { 30111, "INV_Shoulder_07", "=q4=Runetotem's Mantle", "=ds=#s3#, #a2#" },
        { 30106, "INV_Belt_26", "=q4=Belt of One-Hundred Deaths", "=ds=#s10#, #a2#" },
        { 30104, "INV_Boots_Chain_12", "=q4=Cobra-Lash Boots", "=ds=#s12#, #a3#" },
        { 30102, "Inv_Chest_Plate11", "=q4=Krakken-Heart Breastplate", "=ds=#s5#, #a4#" },
        { 30112, "INV_Gauntlets_20", "=q4=Glorious Gauntlets of Crestfall", "=ds=#s9#, #a4#" },
        { 30109, "INV_Jewelry_Ring_44", "=q4=Ring of Endless Coils", "=ds=#s13#" },
        { 30110, "INV_Jewelry_Ring_35", "=q4=Coral Band of the Revived", "=ds=#s13#" },
        { 30621, "Inv_Misc_Gem_Diamond_07", "=q4=Prism of Inner Calm", "=ds=#s14#" },
        { 30103, "INV_Weapon_Shortblade_39", "=q4=Fang of Vashj", "=ds=#h1#, #w4#" },
        { 30108, "INV_Weapon_Shortblade_43", "=q4=Lightfathom Scepter", "=ds=#h3#, #w6#" },
        { 30105, "INV_Weapon_Bow_08", "=q4=Serpent Spine Longbow", "=ds=#w2#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30242, "INV_Helmet_24", "=q4=Helm of the Vanquished Champion", "=ds=#m22# #e15#" },
        { 30243, "INV_Helmet_24", "=q4=Helm of the Vanquished Defender", "=ds=#m22# #e15#" },
        { 30244, "INV_Helmet_24", "=q4=Helm of the Vanquished Hero", "=ds=#m22# #e15#" },
        { 0,"","","" },
        { 32895, "INV_Scroll_05", "=q4=Scroll of the Maelstrom", "=ds=#m20#" },
        { 0,"","","" },
        { 29906, "INV_Potion_100", "=q1=Vashj's Vial Remnant", "=ds=#m3#" },
	};

    CFRSerpentTrash = {
        { 30027, "INV_Boots_Chain_08", "=q4=Boots of Courage Unending", "=ds=#s12#, #a4#" },
        { 30022, "INV_Jewelry_Necklace_AhnQiraj_01", "=q4=Pendant of the Perilous", "=ds=#s2#" },
        { 30620, "INV_Misc_Spyglass_02", "=q4=Spyglass of the Hidden Fleet", "=ds=#s14#" },
        { 30023, "Spell_Nature_EarthBind", "=q4=Totem of the Maelstrom", "=ds=#s16#, #w15#" },
        { 30021, "INV_Staff_50", "=q4=Wildfury Greatstaff", "=ds=#w9#" },
        { 30025, "INV_ThrowingKnife_06", "=q4=Serpentshrine Shuriken", "=ds=#w11#" },
        { 0,"","","" },
        { 30324, "Inv_Scroll_04", "=q4=Plans: Red Havoc Boots", "=ds=#p2# (375)" },
        { 30322, "Inv_Scroll_04", "=q4=Plans: Red Belt of Battle", "=ds=#p2# (375)" },
        { 30323, "Inv_Scroll_04", "=q4=Plans: Boots of the Protector", "=ds=#p2# (375)" },
        { 30321, "Inv_Scroll_04", "=q4=Plans: Belt of the Guardian", "=ds=#p2# (375)" },
        { 30280, "Inv_Scroll_04", "=q4=Pattern: Belt of Blasting", "=ds=#p8# (375)" },
        { 30282, "Inv_Scroll_04", "=q4=Pattern: Boots of Blasting", "=ds=#p8# (375)" },
        { 30283, "Inv_Scroll_04", "=q4=Pattern: Boots of the Long Road", "=ds=#p8# (375)" },
        { 30281, "Inv_Scroll_04", "=q4=Pattern: Belt of the Long Road", "=ds=#p8# (375)" },
        { 30308, "Inv_Scroll_04", "=q4=Pattern: Hurricane Boots", "=ds=#p7# (375)" },
        { 30304, "INV_Scroll_04", "=q4=Pattern: Monsoon Belt", "=ds=#p7# (375)" },
        { 30305, "Inv_Scroll_04", "=q4=Pattern: Boots of Natural Grace", "=ds=#p7# (375)" },
        { 30307, "Inv_Scroll_04", "=q4=Pattern: Boots of the Crimson Hawk", "=ds=#p7# (375)" },
        { 30306, "Inv_Scroll_04", "=q4=Pattern: Boots of Utter Darkness", "=ds=#p7# (375)" },
        { 30301, "Inv_Scroll_04", "=q4=Pattern: Belt of Natural Power", "=ds=#p7# (375)" },
        { 30303, "Inv_Scroll_04", "=q4=Pattern: Belt of the Black Eagle", "=ds=#p7# (375)" },
        { 30302, "Inv_Scroll_04", "=q4=Pattern: Belt of Deep Shadow", "=ds=#p7# (375)" },
        { 0,"","","" },
        { 30183, "INV_Elemental_Mote_Nether", "=q4=Nether Vortex", "=ds=#e6#" },
        { 0,"","","" },
	{ 32897, "Spell_Shadow_Metamorphosis", "=q2=Mark of the Illidari", "=ds=#m20#" },
	};

        -----------------------------
        --- Tempest Keep: The Eye ---
        -----------------------------

    TKEyeVoidReaver = {
        { 29986, "INV_Helmet_14", "=q4=Collar of the Grand Engineer", "=ds=#s1#, #a1#" },
        { 29984, "INV_Belt_08", "=q4=Girdle of Zaetar", "=ds=#s10#, #a2#" },
        { 29985, "INV_Pants_Mail_15", "=q4=Void Reaver Greaves", "=ds=#s11#, #a3#" },
        { 29983, "INV_Helmet_03", "=q4=Fel-Steel Warhelm", "=ds=#s1#, #a4#" },
        { 32515, "Inv_Bracer_19", "=q4=Wristgaurds of Determination", "=ds=#s8#, #a4#" },
        { 30619, "INV_Misc_EngGizmos_14", "=q4=Fel Reaver's Piston", "=ds=#s14#" },
        { 30450, "INV_Gizmo_HardenedAdamantiteTube", "=q4=Warp-Spring Coil", "=ds=#s14#, =q1=#m1# =ds=#c6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30248, "INV_Shoulder_22", "=q4=Pauldrons of the Vanquished Champion", "=ds=#m22# #e15#" },
        { 30249, "INV_Shoulder_22", "=q4=Pauldrons of the Vanquished Defender", "=ds=#m22# #e15#" },
        { 30250, "INV_Shoulder_22", "=q4=Pauldrons of the Vanquished Hero", "=ds=#m22# #e15#" },
	};

    TKEyeAlar = {
        { 29925, "INV_Misc_Cape_08", "=q4=Phoenix-Wing Cloak", "=ds=#s4#" },
        { 29918, "INV_Bracer_13", "=q4=Mindstorm Wristbands", "=ds=#s8#, #a1#" },
        { 29947, "INV_Gauntlets_28", "=q4=Gloves of the Searing Grip", "=ds=#s9#, #a2#" },
        { 29921, "INV_Chest_Plate03", "=q4=Fire Crest Breastplate", "=ds=#s5#, #a3#" },
        { 29922, "INV_Jewelry_Ring_61", "=q4=Band of Al'Ar", "=ds=#s13#" },
        { 29920, "INV_Jewelry_Ring_51naxxramas", "=q4=Phoenix-Ring of Rebirth", "=ds=#s13#" },
        { 30448, "Spell_Fire_Soulburn", "=q4=Talon of Al'ar", "=ds=#s14#, =q1=#m1# =ds=#c2#" },
        { 30447, "INV_Misc_Book_07", "=q4=Tome of Fiery Redemption", "=ds=#s14#, =q1=#m1# =ds=#c4#" },
        { 29923, "INV_Offhand_Blood_02", "=q4=Talisman of the Sun King", "=ds=#s15#" },
        { 29924, "INV_Axe_62", "=q4=Netherbane", "=ds=#h1#, #w1#" },
        { 32944, "Inv_Weapon_Hand_12", "=q4=Talon of the Phoenix", "=ds=#h3#, #w13#" },
        { 29948, "INV_Weapon_Hand_12", "=q4=Claw of the Phoenix", "=ds=#h4#, #w13#" },
        { 29949, "INV_Weapon_Rifle_18", "=q4=Arcanite Steam-Pistol", "=ds=#w5#" },
	};

    TKEyeSolarian = {
        { 29972, "INV_Pants_Cloth_05", "=q4=Trousers of the Astromancer", "=ds=#s11#, #a1#" },
        { 29977, "INV_Pants_Cloth_07", "=q4=Star-Soul Breeches", "=ds=#s11#, #a1#" },
        { 29966, "INV_Bracer_15", "=q4=Vambraces of Ending", "=ds=#s8#, #a2#" },
        { 29976, "INV_Gauntlets_26", "=q4=Worldstorm Gauntlets", "=ds=#s9#, #a3#" },
        { 29951, "INV_Boots_Chain_04", "=q4=Star-Strider Boots", "=ds=#s12#, #a3#" },
        { 29965, "INV_Belt_22", "=q4=Girdle of the Righteous Path", "=ds=#s10#, #a4#" },
        { 29950, "INV_Pants_Plate_05", "=q4=Greaves of the Bloodwarder", "=ds=#s11#, #a4#" },
        { 32267, "Inv_Boots_Plate_06", "=q4=Boots of the Resilient", "=ds=#s12#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30446, "INV_Misc_Gem_Sapphire_01", "=q4=Solarian's Sapphire", "=ds=#s14#, =q1=#m1# =ds=#c9#" },
        { 30449, "INV_Misc_Gem_Ebondraenite_01", "=q4=Void Star Talisman", "=ds=#s14#, =q1=#m1# =ds=#c8#" },
        { 29962, "INV_Weapon_Shortblade_46", "=q4=Heartrazor", "=ds=#h1#, #w4#" },
        { 29981, "INV_Staff_52", "=q4=Etherium Life-Staff", "=ds=#w9#" },
        { 29982, "INV_Wand_15", "=q4=Wand of the Forgotten Star", "=ds=#w12#" },
	};

    TKEyeKaelthas = {
        { 29989, "INV_Misc_Cape_06", "=q4=Sunshower Light Cloak", "=ds=#s4#" },
        { 29994, "INV_Misc_Cape_15", "=q4=Thalassian Wildercloak", "=ds=#s4#" },
        { 29992, "INV_Misc_Cape_10", "=q4=Royal Cloak of the Sunstriders", "=ds=#s4#" },
        { 29990, "INV_Jewelry_Ring_65", "=q4=Crown of the Sun", "=ds=#s1#, #a1#" },
        { 29987, "Inv_Gauntlets_17", "=q4=Gauntlets of the Sun-King", "=ds=#s9#, #a1#" },
        { 29995, "Inv_Pants_Leather_03", "=q4=Leggings of Murderous Intent", "=ds=#s11#, #a2#" },
        { 29991, "INV_Pants_Plate_07", "=q4=Sunhawk Leggings", "=ds=#s11#, #a3#" },
        { 29998, "INV_Gauntlets_29", "=q4=Royal Gauntlets of Silvermoon", "=ds=#s9#, #a4#" },
        { 29997, "Inv_Jewelry_Ring_55", "=q4=Band of the Ranger-General", "=ds=#s13#" },
        { 29996, "INV_Mace_48", "=q4=Rod of the Sun King", "=ds=#h1#, #w6#" },
        { 29993, "INV_Sword_2h_Blood_C_01", "=q4=Twinblade of the Phoenix", "=ds=#h2#, #w10#" },
        { 29988, "INV_Staff_43", "=q4=The Nexus Key", "=ds=#w9#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30236, "INV_Chest_Chain_03", "=q4=Chestguard of the Vanquished Champion", "=ds=#m22# #e15#" },
        { 30237, "INV_Chest_Chain_03", "=q4=Chestguard of the Vanquished Defender", "=ds=#m22# #e15#" },
        { 30238, "INV_Chest_Chain_03", "=q4=Chestguard of the Vanquished Hero", "=ds=#m22# #e15#" },
        { 0,"","","" },
        { 32458, "Inv_Misc_Summerfest_Brazierorange", "=q4=Ashes of Al'ar", "=ds=#e12#" },
        { 0,"","","" },
        { 32405, "INV_Misc_Gem_Pearl_06", "=q4=Verdant Sphere", "=ds=#m2#", "100%" },
        { 30015, "INV_Jewelry_Necklace_14", "=q4=The Sun King's Talisman", "=q1=#m4#: =ds=#s2#" },
        { 30017, "Inv_Jewelry_Necklace_30Naxxramas", "=q4=Telonicus's Pendant of Mayhem", "=q1=#m4#: =ds=#s2#" },
        { 30007, "Inv_Jewelry_Necklace_Ahnqiraj_04", "=q4=The Darkener's Grasp", "=q1=#m4#: =ds=#s2#" },
        { 30018, "INV_Jewelry_Necklace_29Naxxramas", "=q4=Lord Sanguinar's Claim", "=q1=#m4#: =ds=#s2#" },
        { 0,"","","" },
        { 32896, "INV_Scroll_04", "=q4=Scroll of the Sun", "=ds=#m20#" },
        { 0,"","","" },
        { 29905, "INV_Potion_101", "=q1=Kael's Vial Remnant", "=ds=#m3#" },
	};

    TKEyeTrash = {
        { 30024, "INV_Shoulder_25", "=q4=Mantle of the Elven Kings", "=ds=#s3#, #a1#" },
        { 30020, "INV_Belt_03", "=q4=Fire-Cord of the Magus", "=ds=#s10#, #a1#" },
        { 30029, "INV_Gauntlets_25", "=q4=Bark-Gloves of Ancient Wisdom", "=ds=#s9#, #a2#" },
        { 30026, "INV_Bracer_17", "=q4=Bands of the Celestial Archer", "=ds=#s8#, #a3#" },
        { 30030, "INV_Belt_22", "=q4=Girdle of Fallen Stars", "=ds=#s10#, #a3#" },
        { 30028, "INV_Jewelry_Ring_24", "=q4=Seventh Ring of the Tirisfalen", "=ds=#s13#" },
        { 0,"","","" },
        { 30324, "Inv_Scroll_04", "=q4=Plans: Red Havoc Boots", "=ds=#p2# (375)" },
        { 30322, "Inv_Scroll_04", "=q4=Plans: Red Belt of Battle", "=ds=#p2# (375)" },
        { 30323, "Inv_Scroll_04", "=q4=Plans: Boots of the Protector", "=ds=#p2# (375)" },
        { 30321, "Inv_Scroll_04", "=q4=Plans: Belt of the Guardian", "=ds=#p2# (375)" },
        { 30280, "Inv_Scroll_04", "=q4=Pattern: Belt of Blasting", "=ds=#p8# (375)" },
        { 30282, "Inv_Scroll_04", "=q4=Pattern: Boots of Blasting", "=ds=#p8# (375)" },
        { 30283, "Inv_Scroll_04", "=q4=Pattern: Boots of the Long Road", "=ds=#p8# (375)" },
        { 30281, "Inv_Scroll_04", "=q4=Pattern: Belt of the Long Road", "=ds=#p8# (375)" },
        { 30308, "Inv_Scroll_04", "=q4=Pattern: Hurricane Boots", "=ds=#p7# (375)" },
        { 30304, "INV_Scroll_04", "=q4=Pattern: Monsoon Belt", "=ds=#p7# (375)" },
        { 30305, "Inv_Scroll_04", "=q4=Pattern: Boots of Natural Grace", "=ds=#p7# (375)" },
        { 30307, "Inv_Scroll_04", "=q4=Pattern: Boots of the Crimson Hawk", "=ds=#p7# (375)" },
        { 30306, "Inv_Scroll_04", "=q4=Pattern: Boots of Utter Darkness", "=ds=#p7# (375)" },
        { 30301, "Inv_Scroll_04", "=q4=Pattern: Belt of Natural Power", "=ds=#p7# (375)" },
        { 30303, "Inv_Scroll_04", "=q4=Pattern: Belt of the Black Eagle", "=ds=#p7# (375)" },
        { 30302, "Inv_Scroll_04", "=q4=Pattern: Belt of Deep Shadow", "=ds=#p7# (375)" },
        { 0,"","","" },
        { 30183, "INV_Elemental_Mote_Nether", "=q4=Nether Vortex", "=ds=#e6#" },
        { 0,"","","" },
	{ 32897, "Spell_Shadow_Metamorphosis", "=q2=Mark of the Illidari", "=ds=#m20#" },
	};

    TKEyeLegendaries = {
        { 30312, "INV_Weapon_Shortblade_47", "=q5=Infinity Blade", "=ds=#h1#, #w4#" },
        { 30311, "INV_Sword_69", "=q5=Warp Slicer", "=ds=#h1#, #w10#" },
        { 30317, "INV_Mace_48", "=q5=Cosmic Infuser", "=ds=#h3#, #w6#" },
        { 30316, "INV_Axe_68", "=q5=Devastation", "=ds=#h2#, #w1#" },
        { 30318, "INV_Weapon_Bow_19", "=q5=Netherstrand Longbow", "=ds=#w2#, =q1=#m1# =ds=#c2#" },
        { 30313, "INV_Staff_52", "=q5=Staff of Disintegration", "=ds=#w9#" },
        { 30314, "INV_Shield_31", "=q5=Phaseshift Bulwark", "=ds=#w8#" },
        { 30319, "Spell_Arcane_Starfire", "=q5=Nether Spike", "=ds=#w17#" },
	};

	-------------------------------------
	--- Caverns of Time: Hyjal Summit ---
	-------------------------------------

    MountHyjalWinterchill = {
        { 30871, "Inv_Bracer_13", "=q4=Bracers of Martyrdom", "=ds=#s8#, #a1#" },
        { 30870, "INV_Bracer_12", "=q4=Cuffs of Devastation", "=ds=#s8#, #a1#" },
        { 30868, "INV_Bracer_08", "=q4=Rejuvenating Bracers", "=ds=#s8#, #a2#" },
        { 30863, "INV_Bracer_09", "=q4=Deadly Cuffs", "=ds=#s8#, #a2#" },
        { 30869, "INV_Bracer_03", "=q4=Howling Wind Bracers", "=ds=#s8#, #a3#" }, 
        { 30864, "Inv_Bracer_02", "=q4=Bracers of the Pathfinder", "=ds=#s8#, #a3#" },
        { 30873, "INV_Boots_Chain_08", "=q4=Stillwater Boots", "=ds=#s12#, #a3#" },
        { 30866, "Inv_Shoulder_65", "=q4=Blood-stained Pauldrons", "=ds=#s3#, #a4#" },
        { 30861, "Inv_Bracer_15", "=q4=Furious Shackles", "=ds=#s8#, #a4#" },
        { 30862, "INV_Bracer_19", "=q4=Blessed Adamantite Bracers", "=ds=#s8#, #a4#" },
        { 30865, "Inv_Weapon_Shortblade_59", "=q4=Tracker's Blade", "=ds=#h1#, #w4#" },
        { 30872, "Inv_Offhand_Hyjal_d_01", "=q4=Chronicle of Dark Secrets", "=ds=#s15#" },
        { 0,"","","" },
        { 32459, "INV_Potion_19", "=q1=Time-Phased Phylactery", "=ds=#m3#" },
        { 0,"","","" },
        { 32303, "Inv_Scroll_04", "=q4=Design: Inscribed Pyrestone", "=ds=#p12# (375)" },
        { 32307, "Inv_Scroll_04", "=q4=Design: Veiled Pyrestone", "=ds=#p12# (375)" },
        { 32285, "Inv_Scroll_04", "=q4=Design: Flashing Crimson Spinel", "=ds=#p12# (375)" },
        { 32296, "Inv_Scroll_04", "=q4=Design: Great Lionseye", "=ds=#p12# (375)" },
        { 32295, "Inv_Scroll_04", "=q4=Design: Mystic Lionseye", "=ds=#p12# (375)" },
	};

    MountHyjalAnetheron = {
        { 30884, "Inv_Shoulder_68", "=q4=Hatefury Mantle", "=ds=#s3#, #a1#" },
        { 30888, "INV_Belt_03", "=q4=Anetheron's Noose", "=ds=#s10#, #a1#" },
        { 30885, "INV_Boots_Cloth_14", "=q4=Archbishop's Slippers", "=ds=#s12#, #a1#" },
        { 30879, "Inv_Belt_26", "=q4=Don Alejandro's Money Belt", "=ds=#s10#, #a2#" },
        { 30886, "Inv_Boots_Wolf", "=q4=Enchanted Leather Sandals", "=ds=#s12#, #a2#" },
        { 30887, "INV_Chest_Mail_04", "=q4=Golden Links of Restoration", "=ds=#s5#, #a3#" },
        { 30880, "INV_Boots_Chain_09", "=q4=Quickstrider Moccasins", "=ds=#s12#, #a3#" },
        { 30878, "INV_Shoulder_65", "=q4=Glimmering Steel Mantle", "=ds=#s3#, #a4#" },
        { 30874, "Inv_Sword_86", "=q4=The Unbreakable Will", "=ds=#h1#, #w10#" },
        { 30881, "Inv_Sword_85", "=q4=Blade of Infamy", "=ds=#h1#, #w10#" },
        { 30883, "Inv_Staff_60", "=q4=Pillar of Ferocity", "=ds=#h2#, #w9#" },
        { 30882, "INV_Shield_38", "=q4=Bastion of Light", "=ds=#w8#" },
	};

    MountHyjalKazrogal = {
        { 30916, "INV_Pants_Cloth_27", "=q4=Leggings of Channeled Elements", "=ds=#s11#, #a1#" },
        { 30894, "Inv_Boots_Cloth_01", "=q4=Blue Suede Shoes", "=ds=#s12#, #a1#" },
        { 30917, "INV_Shoulder_67", "=q4=Razorfury Mantle", "=ds=#s3#, #a2#" },
        { 30914, "INV_Belt_22", "=q4=Belt of the Crescent Moon", "=ds=#s10#, #a2#" },
        { 30891, "INV_Boots_Cloth_05", "=q4=Black Featherlight Boots", "=ds=#s12#, #a2#" },
        { 30892, "Inv_Shoulder_59", "=q4=Beast-tamer's Shoulders", "=ds=#s3#, #a3#" },
        { 30919, "INV_Belt_22", "=q4=Valestalker Girdle", "=ds=#s10#, #a3#" },
        { 30893, "INV_Pants_Mail_17", "=q4=Sun-touched Chain Leggings", "=ds=#s11#, #a3#" },
        { 30915, "INV_Belt_27", "=q4=Belt of Seething Fury", "=ds=#s10#, #a4#" },
        { 30918, "INV_Mace_57", "=q4=Hammer of Atonement", "=ds=#h3#, #w6#" },
        { 30889, "INV_Shield_39", "=q4=Kaz'rogal's Hardened Heart", "=ds=#w8#" },
	};

    MountHyjalAzgalor = {
        { 30895, "INV_Belt_08", "=q4=Angelista's Sash", "=ds=#s10#, #a1#" },
        { 30899, "INV_Chest_Leather_01", "=q4=Don Rodrigo's Poncho", "=ds=#s5#, #a2#" },
        { 30898, "Inv_Pants_Leather_25", "=q4=Shady Dealer's Pantaloons", "=ds=#s11#, #a2#" },
        { 30900, "INV_Pants_Mail_15", "=q4=Bow-stitched Leggings", "=ds=#s11#, #a3#" },
        { 30896, "INV_Chest_Plate02", "=q4=Glory of the Defender", "=ds=#s5#, #a4#" },
        { 30897, "INV_Belt_28", "=q4=Girdle of Hope", "=ds=#s10#, #a4#" },
        { 30901, "Inv_Weapon_Shortblade_59", "=q4=Boundless Agony", "=ds=#h1#, #w4#" },
        { 0,"","","" },
        { 32289, "Inv_Scroll_04", "=q4=Design: Stormy Empyrean Sapphire", "=ds=#p12# (375)" },
        { 32298, "Inv_Scroll_04", "=q4=Design: Shifting Shadowsong Amethyst", "=ds=#p12# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31092, "Inv_Gauntlets_27", "=q4=Gloves of the Forgotten Conqueror", "=ds=#m23# #e15#" },
        { 31094, "Inv_Gauntlets_27", "=q4=Gloves of the Forgotten Protector", "=ds=#m23# #e15#" },
        { 31093, "Inv_Gauntlets_27", "=q4=Gloves of the Forgotten Vanquisher", "=ds=#m23# #e15#" },
	};

    MountHyjalArchimonde = {
        { 30913, "Inv_Chest_Cloth_49", "=q4=Robes of Rhonin", "=ds=#s5#, #a1#" },
        { 30912, "Inv_Pants_Cloth_14", "=q4=Leggings of Eternity", "=ds=#s11#, #a1#" },
        { 30905, "Inv_Chest_Plate02", "=q4=Midnight Chestguard", "=ds=#s5#, #a2#" },
        { 30907, "INV_Chest_Chain_17", "=q4=Mail of Fevered Pursuit", "=ds=#s5#, #a3#" },
        { 30904, "Inv_Chest_Plate02", "=q4=Savior's Grasp", "=ds=#s5#, #a4#" },
        { 30903, "Inv_Pants_Plate_21", "=q4=Legguards of Endless Rage", "=ds=#s11#, #a4#" },
        { 30911, "Inv_Offhand_Draenei_A_01", "=q4=Scepter of Purification", "=ds=#s15#" },
        { 30910, "Inv_Sword_90", "=q4=Tempest of Chaos", "=ds=#h3#, #w10#" },
        { 30902, "INV_Sword_68", "=q4=Cataclysm's Edge", "=ds=#h2#, #w10#" },
        { 30908, "INV_Staff_54", "=q4=Apostle of Argus", "=ds=#w9#" },
        { 30909, "Inv_Shield_40", "=q4=Antonidas's Aegis of Rapt Concentration", "=ds=#w8#" },
        { 30906, "Inv_Weapon_Bow_30", "=q4=Bristleblitz Striker", "=ds=#w2#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31097, "Inv_Helmet_24", "=q4=Helm of the Forgotten Conqueror", "=ds=#m23# #e15#" },
        { 31095, "Inv_Helmet_24", "=q4=Helm of the Forgotten Protector", "=ds=#m23# #e15#" },
        { 31096, "Inv_Helmet_24", "=q4=Helm of the Forgotten Vanquisher", "=ds=#m23# #e15#" },
	};

	--------------------
	--- Black Temple ---
	--------------------

    BTNajentus = {
        { 32239, "Inv_Boots_Cloth_16", "=q4=Slippers of the Seacaller", "=ds=#s12#, #a1#" },
        { 32240, "Inv_Helmet_94", "=q4=Guise of the Tidal Lurker", "=ds=#s1#, #a2#" },
        { 32377, "Inv_Shoulder_67", "=q4=Mantle of Darkness", "=ds=#s5#, #a2#" },
        { 32241, "Inv_Helmet_97", "=q4=Helm of Soothing Currents", "=ds=#s1#, #a3#" },
        { 32234, "INV_Gauntlets_59", "=q4=Fists of Mukoa", "=ds=#s9#, #a3#" },
        { 32242, "Inv_Boots_Chain_12", "=q4=Boots of Oceanic Fury", "=ds=#s12#, #a3#" },
        { 32232, "INV_Bracer_14", "=q4=Eternium Shell Bracers", "=ds=#s8#, #a4#" },
        { 32245, "Inv_Boots_Plate_04", "=q4=Tide-stomper's Greaves", "=ds=#s12#, #a4#" },
        { 32243, "INV_Boots_Chain_08", "=q4=Pearl Inlaid Boots", "=ds=#s12#, #a4#" },
        { 32238, "INV_Jewelry_Ring_57", "=q4=Ring of Calming Waves", "=ds=#s13#" },
        { 32247, "INV_Jewelry_Ring_60", "=q4=Ring of Captured Storms", "=ds=#s13#" },
        { 32237, "Inv_Weapon_Shortblade_58", "=q4=The Maelstrom's Fury", "=ds=#h1#, #w4#" },
        { 32236, "Inv_Axe_56", "=q4=Rising Tide", "=ds=#h1#, #w1#" },
        { 32248, "INV_Weapon_Halberd_20", "=q4=Halberd of Desolation", "=ds=#h2#, #w7#" },
        { 0,"","","" },
        { 32738, "INV_Scroll_04", "=q4=Plans: Dawnsteel Bracers", "=ds=#p2# (375)" },
        { 32754, "INV_Scroll_04", "=q4=Pattern: Bracers of Nimble Thought", "=ds=#p2# (375)" },
        { 32750, "INV_Scroll_04", "=q4=Pattern: Living Earth Bindings", "=ds=#p7# (375)" },
        { 32744, "INV_Scroll_04", "=q4=Pattern: Bracers of Renewed Life", "=ds=#p7# (375)" },
        { 32747, "INV_Scroll_04", "=q4=Pattern: Swiftstrike Shoulders", "=ds=#p7# (375)" },
        { 32753, "INV_Scroll_04", "=q4=Pattern: Swiftheal Mantle", "=ds=#p8# (375)" },
	};

    BTSupremus = {
        { 32256, "Inv_Belt_03", "=q4=Waistwrap of Infinity", "=ds=#s10#, #a1#" },
        { 32252, "Inv_Chest_Leather_03", "=q4=Nether Shadow Tunic", "=ds=#s6#, #a2#" },
        { 32251, "Inv_Bracer_06", "=q4=Wraps of Precise Flight", "=ds=#s8#, #a3#" },
        { 32259, "INV_Bracer_02", "=q4=Bands of the Coming Storm", "=ds=#s8#, #a3#" },
        { 32258, "INV_Belt_22", "=q4=Naturalist'S Preserving Cinch", "=ds=#s10#, #a3#" },
        { 32250, "Inv_Shoulder_Haremmatron_d_01", "=q4=Pauldrons of Abyssal Fury", "=ds=#s3#, #a4#" },
        { 0,"","","" },
        { 32737, "INV_Scroll_04", "=q4=Plans: Swiftsteel Shoulders", "=ds=#p2# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32260, "INV_Jewelry_Necklace_36", "=q4=Choker of Endless Nightmares", "=ds=#s2#" },
        { 32261, "INV_Jewelry_Ring_70", "=q4=Band of the Abyssal Lord", "=ds=#s13#" },
        { 32257, "Inv_Qirajidol_Alabaster", "=q4=Idol of the White Stag", "=ds=#s16#, #w14#" },
        { 32254, "Inv_Axe_59", "=q4=The Brutalizer", "=ds=#h1#, #w1#" },
        { 32262, "Inv_Mace_44", "=q4=Syphon of the Nathrezim", "=ds=#h1#, #w6#" },
        { 32255, "Inv_Shield_38", "=q4=Felstone Bulwark", "=ds=#w8#" },
        { 32253, "Inv_Weapon_Crossbow_20", "=q4=Legionkiller", "=ds=#w3#" },
	};

    BTGorefiend = {
        { 32323, "INV_Misc_Cape_Naxxramas_02", "=q4=Shadowmoon Destroyer's Drape", "=ds=#s4#" },
        { 32329, "Inv_Helmet_32", "=q4=Cowl of Benevolence", "=ds=#s1#, #a1#" },
        { 32327, "INV_Chest_Cloth_51", "=q4=Robe of the Shadow Council", "=ds=#s5#, #a1#" },
        { 32324, "INV_Bracer_04", "=q4=Insidious Bands", "=ds=#s8#, #a2#" },
        { 32328, "Inv_Gauntlets_24", "=q4=Botanist's Gloves of Growth", "=ds=#s9#, #a2#" },
        { 32510, "INV_Boots_Chain_01", "=q4=Softstep Boots of Tracking", "=ds=#s12#, #a3#" },
        { 32280, "Inv_Gauntlets_62", "=q4=Gauntlets of Enforcement", "=ds=#s9#, #a4#" },
        { 32512, "INV_Belt_28", "=q4=Girdle of Lordaeron's Fallen", "=ds=#s10#, #a4#" },
        { 0,"","","" },
        { 32746, "Inv_Scroll_04", "=q4=Pattern: Swiftstrike Bracers", "=ds=#p7# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32330, "Spell_Nature_GiftoftheWaterSpirit", "=q4=Totem of Ancestral Guidance", "=ds=#s16#, #w15#" },
        { 32348, "INV_Axe_60", "=q4=Soul Cleaver", "=ds=#h2#, #w1#" },
        { 32326, "INV_ThrowingKnife_04", "=q4=Twisted Blades of Zarak", "=ds=#w11#" },
        { 32325, "INV_Weapon_Rifle_21", "=q4=Rifle of the Stoic Guardian", "=ds=#w5#" },
	};

    BTBloodboil = {
        { 32337, "INV_Misc_Cape_13", "=q4=Shroud of Forgiveness", "=ds=#s4#" },
        { 32338, "INV_Shoulder_02", "=q4=Blood-cursed Shoulderpads", "=ds=#s3#, #a1#" },
        { 32340, "INV_Chest_Cloth_35", "=q4=Garments of Temperance", "=ds=#s5#, #a1#" },
        { 32339, "INV_Belt_24", "=q4=Belt of Primal Majesty", "=ds=#s10#, #a2#" },
        { 32334, "Inv_Chest_Samurai", "=q4=Vest of Mounting Assault", "=ds=#s5#, #a3#" },
        { 32342, "INV_Belt_27", "=q4=Girdle of Mighty Resolve", "=ds=#s10#, #a4#" },
        { 32333, "INV_Belt_33", "=q4=Girdle of Stability", "=ds=#s10#, #a4#" },
        { 32341, "Inv_Pants_Plate_20", "=q4=Leggings of Divine Retribution", "=ds=#s11#, #a4#" },
        { 0,"","","" },
        { 32752, "Inv_Scroll_04", "=q4=Pattern: Swiftheal Wraps", "=ds=#p8# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32335, "INV_Jewelry_Ring_71", "=q4=Unstoppable Aggressor's Ring", "=ds=#s13#" },
        { 32501, "Inv_Jewelcrafting_Shadowsongamethyst_01", "=q4=Shadowmoon Insignia", "=ds=#s14#" },
        { 32269, "INV_Weapon_Shortblade_63", "=q4=Messenger of Fate", "=ds=#h1#, #w4#" },
        { 32344, "INV_Staff_61", "=q4=Staff of Immaculate Recovery", "=ds=#w9#" },
        { 32343, "Inv_Wand_16", "=q4=Wand of Prismatic Focus", "=ds=#w12#" },
	};

    BTAkama = {
        { 32273, "Inv_Shoulder_63", "=q4=Amice of Brilliant Light", "=ds=#s3#, #a1#" },
        { 32270, "Inv_Bracer_10", "=q4=Focused Mana Bindings", "=ds=#s8#, #a1#" },
        { 32513, "Inv_Bracer_13", "=q4=Wristbands of Divine Influence", "=ds=#s8#, #a1#" },
        { 32265, "INV_Belt_26", "=q4=Shadow-walker's Cord", "=ds=#s10#, #a2#" },
        { 32271, "Inv_Pants_Leather_23", "=q4=Kilt of Immortal Nature", "=ds=#s11#, #a2#" },
        { 32264, "Inv_Shoulder_59", "=q4=Shoulders of the Hidden Predator", "=ds=#s3#, #a3#" },
        { 32275, "INV_Gauntlets_61", "=q4=Spiritwalker Gauntlets", "=ds=#s9#, #a3#" },
        { 32276, "INV_Belt_13", "=q4=Flashfire Girdle", "=ds=#s10#, #a3#" },
        { 32279, "INV_Bracer_17", "=q4=The Seeker's Wristguards", "=ds=#s8#, #a4#" },
        { 32278, "INV_Gauntlets_60", "=q4=Grips of Silent Justice", "=ds=#s9#, #a4#" },
        { 32263, "Inv_Pants_Plate_07", "=q4=Praetorian's Legguards", "=ds=#s11#, #a4#" },
        { 32268, "INV_Boots_Plate_06", "=q4=Myrmidon's Treads", "=ds=#s12#, #a4#" },
        { 32266, "Inv_Jewelry_Ring_68", "=q4=Ring of Deceitful Intent", "=ds=#s13#" },
        { 32361, "INV_Misc_Orb_05", "=q4=Blind-Seers Icon", "=ds=#s15#" },
        { 0,"","","" },
        { 32739, "Inv_Scroll_04", "=q4=Plans: Dawnsteel Shoulders", "=ds=#p2# (375)" },
	};

    BTEssencofSouls = {
        { 32353, "INV_Gauntlets_63", "=q4=Gloves of Unfailing Faith", "=ds=#s9#, #a1#" },
        { 32351, "INV_Bracer_09", "=q4=Elunite Empowered Bracers", "=ds=#s8#, #a2#" },
        { 32347, "INV_Gauntlets_65", "=q4=Grips of Damnation", "=ds=#s9#, #a2#" },
        { 32352, "INV_Boots_08", "=q4=Naturewarden's Treads", "=ds=#s12#, #a2#" },
        { 32517, "INV_Shoulder_61", "=q4=The Wavemender's Mantle", "=ds=#s3#, #a3#" },
        { 32346, "INV_Belt_14", "=q4=Boneweave Girdle", "=ds=#s10#, #a3#" },
        { 32354, "INV_Helmet_96", "=q4=Crown of Empowered Fate", "=ds=#s1#, #a4#" },
        { 32345, "INV_Boots_Plate_02", "=q4=Dreadboots of the Legion", "=ds=#s12#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32349, "INV_Jewelry_Necklace_30", "=q4=Translucent Spellthread Necklace", "=ds=#s2#" },
        { 32362, "INV_Jewelry_Amulet_03", "=q4=Pendant of Titans", "=ds=#s2#" },
        { 32350, "INV_Misc_Gem_Ebondraenite_02", "=q4=Touch of Inspiration", "=ds=#s15#" },
        { 32332, "INV_Mace_49", "=q4=Torch of the Damned", "=ds=#h2#, #w6#" },
        { 32363, "INV_Wand_15", "=q4=Naaru-Blessed Life Rod", "=ds=#w12#" },
	};

    BTShahraz = {
        { 32366, "INV_Boots_Cloth_02", "=q4=Shadowmaster's Boots", "=ds=#s12#, #a1#" },
        { 32367, "INV_Pants_Cloth_15", "=q4=Leggings of Devastation", "=ds=#s11#, #a1#" },
        { 32365, "INV_Chest_Plate08", "=q4=Heartshatter Breastplate", "=ds=#s5#, #a4#" },
        { 32370, "INV_Jewelry_Necklace_32", "=q4=Nadina's Pendant of Purity", "=ds=#s2#" },
        { 32368, "INV_Relics_Libramofhope", "=q4=Tome of the Lightbringer", "=ds=#s16#, #w16#" },
        { 32369, "Inv_Sword_87", "=q4=Blade of Savagery", "=ds=#h1#, #w10#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31101, "Inv_Shoulder_22", "=q4=Pauldrons of the Forgotten Conqueror", "=ds=#m23# #e15#" },
        { 31103, "Inv_Shoulder_22", "=q4=Pauldrons of the Forgotten Protector", "=ds=#m23# #e15#" },
        { 31102, "Inv_Shoulder_22", "=q4=Pauldrons of the Forgotten Vanquisher", "=ds=#m23# #e15#" },
	};

    BTCouncil = {
        { 32331, "INV_Misc_Cape_20", "=q4=Cloak of the Illidari Council", "=ds=#s4#" },
        { 32519, "INV_Belt_07", "=q4=Belt of Divine Guidance", "=ds=#s10#, #a1#" },
        { 32518, "INV_Shoulder_58", "=q4=Veil of Turning Leaves", "=ds=#s3#, #a2#" },
        { 32376, "INV_Helmet_95", "=q4=Forest Prowler's Helm", "=ds=#s1#, #a3#" },
        { 32373, "INV_Helmet_98", "=q4=Helm of the Illidari Shatterer", "=ds=#a1#, #s4#" },
        { 32505, "Spell_Shadow_Charm", "=q4=Madness of the Betrayer", "=ds=#s13#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31098, "INV_Pants_Plate_17", "=q4=Leggings of the Forgotten Conqueror", "=ds=#m23# #e15#" },
        { 31100, "INV_Pants_Plate_17", "=q4=Leggings of the Forgotten Protector", "=ds=#m23# #e15#" },
        { 31099, "INV_Pants_Plate_17", "=q4=Leggings of the Forgotten Vanquisher", "=ds=#m23# #e15#" },
	};

    BTIllidanStormrage = {
        { 32524, "INV_Misc_Cape_06", "=q4=Shroud of the Highborne", "=ds=#s4#" },
        { 32525, "INV_Helmet_53", "=q4=Cowl of the Illidari High Lord", "=ds=#s1#, #a1#" },
        { 32235, "INV_Misc_Bandana_03", "=q4=Cursed Vision of Sargeras", "=ds=#s1#, #a2#" },
        { 32521, "INV_Helmet_98", "=q4=Faceplate of the Impenetrable", "=ds=#s1#, #a4#" },
        { 32497, "INV_Jewelry_Ring_67", "=q4=Stormrage Signet Ring", "=ds=#s13#" },
        { 32483, "INV_Misc_Bone_Elfskull_01", "=q4=The Skull of Gul'dan", "=ds=#s14#" },
        { 32496, "INV_Summerfest_Fireflower", "=q4=Memento of Tyrande", "=ds=#s14#" },
        { 0,"","","" },
        { 32837, "INV_Weapon_Glave_01", "=q5=Warglaive of Azzinoth", "=ds=#h3#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 32838, "INV_Weapon_Glave_01", "=q5=Warglaive of Azzinoth", "=ds=#h4#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31089, "INV_Chest_Chain_03", "=q4=Chestguard of the Forgotten Conqueror", "=ds=#m23# #e15#" },
        { 31091, "INV_Chest_Chain_03", "=q4=Chestguard of the Forgotten Protector", "=ds=#m23# #e15#" },
        { 31090, "INV_Chest_Chain_03", "=q4=Chestguard of the Forgotten Vanquisher", "=ds=#m23# #e15#" },
        { 0,"","","" },
        { 32471, "INV_Weapon_Shortblade_62", "=q4=Shard of Azzinoth", "=ds=#h1#, #w4#" },
        { 32500, "INV_Mace_56", "=q4=Crystal Spire of Karabor", "=ds=#h3#, #w6#" },
        { 32375, "INV_Shield_32", "=q4=Bulwark of Azzinoth", "=ds=#w8#" },
        { 32374, "INV_Staff_59", "=q4=Zhar'doom, Greatstaff of the Devourer", "=ds=#w9#" },
        { 32336, "INV_Weapon_Bow_31", "=q4=Black Bow of the Betrayer", "=ds=#w2#" },
	};

    BTTrash = {
        { 32590, "INV_Misc_Cape_10", "=q4=Nethervoid Cloak", "=ds=#s4#" },
        { 32609, "INV_Boots_Cloth_08", "=q4=Boots of the Divine Light", "=ds=#s12#, #a1#" },
        { 32589, "INV_Jewelry_Necklace_17", "=q4=Hellfire-Encased Pendant", "=ds=#s12#, #a2#" },
        { 32592, "Inv_Chest_Chain_11", "=q4=Chestguard of Relentless Storms", "=ds=#s5#, #a3#" },
        { 32608, "Inv_Gauntlets_62", "=q4=Pillager's Gauntlets", "=ds=#s11#, #a4#" },
        { 32606, "INV_Belt_28", "=q4=Girdle of the Lightbearer", "=ds=#s10#, #a4#" },
        { 32593, "INV_Boots_Wolf", "=q4=Treads of the Den Mother", "=ds=#s2#" },
        { 32591, "INV_Jewelry_Necklace_34", "=q4=Choker of Serrated Blades", "=ds=#s2#" },
        { 32527, "Inv_Jewelry_Ring_35", "=q4=Ring of Ancient Knowledge", "=ds=#s13#" },
        { 32528, "Inv_Jewelry_Ring_35", "=q4=Blessed Band of Karabor", "=ds=#s13#" },
        { 32526, "INV_Jewelry_Ring_35", "=q4=Band of Devastation", "=ds=#s13#" },
        { 32943, "Inv_Mace_44", "=q4=Swiftsteel Bludgeon", "=ds=#h1#, #w6#" },
        { 0,"","","" },
	{ 32897, "Spell_Shadow_Metamorphosis", "=q2=Mark of the Illidari", "=ds=#m20#" },
	{ 0,"","","" },
        { 32228, "INV_Jewelcrafting_EmpyreanSapphire_01", "=q4=Empyrean Sapphire", "=ds=#e7#" },
        { 32231, "INV_Jewelcrafting_Pyrestone_01", "=q4=Pyrestone", "=ds=#e7#" },
        { 32229, "INV_Jewelcrafting_Lionseye_01", "=q4=Lionseye", "=ds=#e7#" },
        { 32249, "INV_Jewelcrafting_SeasprayEmerald_01", "=q4=Seaspray Emerald", "=ds=#e7#" },
        { 32230, "INV_Jewelcrafting_ShadowsongAmethyst_01", "=q4=Shadowsong Amethyst", "=ds=#e7#" },
        { 32227, "INV_Jewelcrafting_CrimsonSpinel_01", "=q4=Crimson Spinel", "=ds=#e7#" },
        { 0,"","","" },
        { 32736, "INV_Scroll_04", "=q4=Plans: Swiftsteel Bracers", "=ds=#p2# (375)" },
	{ 32748, "INV_Scroll_04", "=q4=Pattern: Bindings of Lightning Reflexes", "=ds=#p7# (375)" },
        { 32749, "Inv_Scroll_04", "=q4=Pattern: Shoulders of Lightning Reflexes", "=ds=#p7# (375)" },
        { 32744, "INV_Scroll_04", "=q4=Pattern: Bracers of Renewed Life", "=ds=#p7# (375)" },
        { 32755, "INV_Scroll_04", "=q4=Pattern: Mantle of Nimble Thought", "=ds=#p8# (375)" },
        { 0,"","","" },
        { 32428, "Spell_Shadow_Demonictactics", "=q3=Heart of Darkness", "=ds=#e8#" },
	};

	----------------
	--- Zul'Aman ---
	----------------

   ZANalorakk = {
        { 0,"?","=q4=Bear Mount","=ds=#e12#" },
	};  

   ZAJanAlai = {
        { 0,"","","" },
	};  

   ZAAkilZon = {
        { 0,"","","" },
	};  

   ZAHalazzi = {
        { 0,"","","" },
	};  

   ZAJinZakk = {
        { 0,"","","" },
	};  

   ZAZuljin = {
        { 0,"","","" },
	};  

   UnknownZulAmanBoss = {
        { 0,"?","=q4=Dagger of Bad Mojo","=ds=#h1#, #w4#" },
        { 0,"?","=q4=Jin'rohk, The Great Apocalypse","=ds=#h2#, #w10#" },
        { 0,"?","=q3=Formula: Enchant Weapon - Executioner","=ds=#p4# (375)" },
	};    	
};